/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class StringParameter
implements Cloneable,
ParameterHolder {
    private final String stringValue;
    private final boolean noBackslashEscapes;

    public StringParameter(String str, boolean noBackslashEscapes) {
        this.stringValue = str;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(this.stringValue, true, this.noBackslashEscapes);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.stringValue.length() * 3;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        byte[] bytes = this.stringValue.getBytes("UTF-8");
        pos.writeFieldLength(bytes.length);
        pos.write(bytes);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.VARCHAR;
    }

    @Override
    public String toString() {
        if (this.stringValue.length() < 1024) {
            return "'" + this.stringValue + "'";
        }
        return "'" + this.stringValue.substring(0, 1024) + "...'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

