/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;

public class SendOldPasswordAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    public SendOldPasswordAuthPacket(String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException {
        if (this.password == null || this.password.isEmpty()) {
            pos.writeEmptyPacket(this.packSeq);
            return;
        }
        pos.startPacket(this.packSeq);
        byte[] seed = Utils.copyWithLength(this.authData, 8);
        pos.write(this.cryptOldFormatPassword(this.password, new String(seed)));
        pos.write(0);
        pos.flush();
    }

    private byte[] cryptOldFormatPassword(String password, String seed) {
        byte[] result = new byte[seed.length()];
        if (password == null || password.length() == 0) {
            return new byte[0];
        }
        long[] seedHash = this.hashPassword(seed);
        long[] passHash = this.hashPassword(password);
        RandStruct randSeed = new RandStruct(seedHash[0] ^ passHash[0], seedHash[1] ^ passHash[1]);
        for (int i = 0; i < seed.length(); ++i) {
            result[i] = (byte)Math.floor(this.random(randSeed) * 31.0 + 64.0);
        }
        byte extra = (byte)Math.floor(this.random(randSeed) * 31.0);
        int i = 0;
        while (i < seed.length()) {
            int n = i++;
            result[n] = (byte)(result[n] ^ extra);
        }
        return result;
    }

    private double random(RandStruct rand) {
        rand.seed1 = (rand.seed1 * 3L + rand.seed2) % 0x3FFFFFFFL;
        rand.seed2 = (rand.seed1 + rand.seed2 + 33L) % 0x3FFFFFFFL;
        return (double)rand.seed1 / 1.073741823E9;
    }

    private long[] hashPassword(String password) {
        long nr = 1345345333L;
        long nr2 = 305419889L;
        long add = 7L;
        for (int i = 0; i < password.length(); ++i) {
            char currChar = password.charAt(i);
            if (currChar == ' ' || currChar == '\t') continue;
            nr ^= ((nr & 0x3FL) + add) * (long)currChar + (nr << 8);
            nr2 += nr2 << 8 ^ nr;
            add += (long)currChar;
        }
        return new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
    }

    private class RandStruct {
        private final long maxValue = 0x3FFFFFFFL;
        private long seed1;
        private long seed2;

        public RandStruct(long seed1, long seed2) {
            this.seed1 = seed1 % 0x3FFFFFFFL;
            this.seed2 = seed2 % 0x3FFFFFFFL;
        }
    }
}

