/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.AbstractAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.send.InterfaceAuthSwitchSendResponsePacket;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.io.output.PacketOutputStream;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Utils;

public class SendNativePasswordAuthPacket
extends AbstractAuthSwitchSendResponsePacket
implements InterfaceAuthSwitchSendResponsePacket {
    public SendNativePasswordAuthPacket(String password, byte[] authData, int packSeq, String passwordCharacterEncoding) {
        super(packSeq, authData, password, passwordCharacterEncoding);
    }

    @Override
    public void send(PacketOutputStream pos) throws IOException {
        try {
            if (this.password == null || this.password.isEmpty()) {
                pos.writeEmptyPacket(this.packSeq);
                return;
            }
            pos.startPacket(this.packSeq);
            byte[] seed = this.authData.length > 0 ? Arrays.copyOfRange(this.authData, 0, this.authData.length - 1) : new byte[]{};
            pos.write(Utils.encryptPassword(this.password, seed, this.passwordCharacterEncoding));
            pos.flush();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not use SHA-1, failing", e);
        }
    }
}

