/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.rowprotocol;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.TimeZone;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.ColumnType;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.rowprotocol.RowProtocol;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.Options;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.util.exceptions.ExceptionMapper;

public class BinaryRowProtocol
extends RowProtocol {
    private final ColumnInformation[] columnInformation;
    private final int columnInformationLength;

    public BinaryRowProtocol(ColumnInformation[] columnInformation, int columnInformationLength, int maxFieldSize, Options options) {
        super(maxFieldSize, options);
        this.columnInformation = columnInformation;
        this.columnInformationLength = columnInformationLength;
    }

    @Override
    public void setPosition(int newIndex) {
        if ((this.buf[1 + (newIndex + 2) / 8] & 1 << (newIndex + 2) % 8) != 0) {
            this.lastValueNull = 1;
            return;
        }
        if (this.index != newIndex) {
            int internalPos = this.pos;
            if (this.index == -1 || this.index > newIndex) {
                this.index = 0;
                internalPos = 1 + (this.columnInformationLength + 9) / 8;
            } else {
                ++this.index;
                internalPos += this.length;
            }
            while (this.index <= newIndex) {
                if ((this.buf[1 + (this.index + 2) / 8] & 1 << (this.index + 2) % 8) == 0) {
                    int type;
                    if (this.index != newIndex) {
                        block0 : switch (this.columnInformation[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                internalPos += 8;
                                break;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                internalPos += 4;
                                break;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                internalPos += 2;
                                break;
                            }
                            case TINYINT: {
                                ++internalPos;
                                break;
                            }
                            default: {
                                type = this.buf[internalPos++] & 0xFF;
                                switch (type) {
                                    case 251: {
                                        break block0;
                                    }
                                    case 252: {
                                        internalPos += 2 + (0xFFFF & (this.buf[internalPos] & 0xFF) + ((this.buf[internalPos + 1] & 0xFF) << 8));
                                        break block0;
                                    }
                                    case 253: {
                                        internalPos += 3 + (0xFFFFFF & (this.buf[internalPos] & 0xFF) + ((this.buf[internalPos + 1] & 0xFF) << 8) + ((this.buf[internalPos + 2] & 0xFF) << 16));
                                        break block0;
                                    }
                                    case 254: {
                                        internalPos = (int)((long)internalPos + (8L + ((long)(this.buf[internalPos] & 0xFF) + ((long)(this.buf[internalPos + 1] & 0xFF) << 8) + ((long)(this.buf[internalPos + 2] & 0xFF) << 16) + ((long)(this.buf[internalPos + 3] & 0xFF) << 24) + ((long)(this.buf[internalPos + 4] & 0xFF) << 32) + ((long)(this.buf[internalPos + 5] & 0xFF) << 40) + ((long)(this.buf[internalPos + 6] & 0xFF) << 48) + ((long)(this.buf[internalPos + 7] & 0xFF) << 56))));
                                        break block0;
                                    }
                                }
                                internalPos += type;
                                break;
                            }
                        }
                    } else {
                        switch (this.columnInformation[this.index].getColumnType()) {
                            case BIGINT: 
                            case DOUBLE: {
                                this.pos = internalPos;
                                this.length = 8;
                                this.lastValueNull = 0;
                                return;
                            }
                            case INTEGER: 
                            case MEDIUMINT: 
                            case FLOAT: {
                                this.pos = internalPos;
                                this.length = 4;
                                this.lastValueNull = 0;
                                return;
                            }
                            case SMALLINT: 
                            case YEAR: {
                                this.pos = internalPos;
                                this.length = 2;
                                this.lastValueNull = 0;
                                return;
                            }
                            case TINYINT: {
                                this.pos = internalPos;
                                this.length = 1;
                                this.lastValueNull = 0;
                                return;
                            }
                        }
                        type = this.buf[internalPos++] & 0xFF;
                        switch (type) {
                            case 251: {
                                throw new IllegalStateException("null data is encoded in binary protocol but NULL-Bitmap is not set");
                            }
                            case 252: {
                                this.length = 0xFFFF & (this.buf[internalPos++] & 0xFF) + ((this.buf[internalPos++] & 0xFF) << 8);
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                            case 253: {
                                this.length = 0xFFFFFF & (this.buf[internalPos++] & 0xFF) + ((this.buf[internalPos++] & 0xFF) << 8) + ((this.buf[internalPos++] & 0xFF) << 16);
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                            case 254: {
                                this.length = (int)((long)(this.buf[internalPos++] & 0xFF) + ((long)(this.buf[internalPos++] & 0xFF) << 8) + ((long)(this.buf[internalPos++] & 0xFF) << 16) + ((long)(this.buf[internalPos++] & 0xFF) << 24) + ((long)(this.buf[internalPos++] & 0xFF) << 32) + ((long)(this.buf[internalPos++] & 0xFF) << 40) + ((long)(this.buf[internalPos++] & 0xFF) << 48) + ((long)(this.buf[internalPos++] & 0xFF) << 56));
                                this.pos = internalPos;
                                this.lastValueNull = 0;
                                return;
                            }
                        }
                        this.length = type;
                        this.pos = internalPos;
                        this.lastValueNull = 0;
                        return;
                    }
                }
                ++this.index;
            }
        }
        this.lastValueNull = this.length == -1 ? 1 : 0;
    }

    @Override
    public String getInternalString(ColumnInformation columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if ((this.lastValueNull & 1) != 0) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case STRING: {
                if (this.getMaxFieldSize() > 0) {
                    return new String(this.buf, this.pos, Math.max(this.getMaxFieldSize() * 3, this.length), StandardCharsets.UTF_8).substring(0, this.getMaxFieldSize());
                }
                return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
            }
            case BIT: {
                return String.valueOf(this.parseBit());
            }
            case TINYINT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalTinyInt(columnInfo)), columnInfo);
            }
            case SMALLINT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalSmallInt(columnInfo)), columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalMediumInt(columnInfo)), columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.zeroFillingIfNeeded(String.valueOf(this.getInternalBigInteger(columnInfo)), columnInfo);
                }
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalLong(columnInfo)), columnInfo);
            }
            case DOUBLE: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalDouble(columnInfo)), columnInfo);
            }
            case FLOAT: {
                return this.zeroFillingIfNeeded(String.valueOf(this.getInternalFloat(columnInfo)), columnInfo);
            }
            case TIME: {
                return this.getInternalTimeString(columnInfo);
            }
            case DATE: {
                Date date = this.getInternalDate(columnInfo, cal, timeZone);
                if (date == null) {
                    return null;
                }
                return date.toString();
            }
            case YEAR: {
                if (this.options.yearIsDateType) {
                    Date dateInter = this.getInternalDate(columnInfo, cal, timeZone);
                    return dateInter == null ? null : dateInter.toString();
                }
                return String.valueOf(this.getInternalSmallInt(columnInfo));
            }
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone);
                if (timestamp == null) {
                    return null;
                }
                return timestamp.toString();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                return bigDecimal == null ? null : this.zeroFillingIfNeeded(bigDecimal.toString(), columnInfo);
            }
            case GEOMETRY: {
                return new String(this.buf, this.pos, this.length);
            }
            case NULL: {
                return null;
            }
        }
        if (this.getMaxFieldSize() > 0) {
            return new String(this.buf, this.pos, Math.max(this.getMaxFieldSize() * 3, this.length), StandardCharsets.UTF_8).substring(0, this.getMaxFieldSize());
        }
        return new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public int getInternalInt(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                value = this.parseBit();
                break;
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                if (columnInfo.isSigned()) {
                    return (int)value;
                }
                if (value >= 0L) break;
                value &= 0xFFFFFFFFL;
                break;
            }
            case BIGINT: {
                value = this.getInternalLong(columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getInternalFloat(columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getInternalDouble(columnInfo);
                break;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, bigDecimal, columnInfo);
                return bigDecimal.intValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                value = Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new SQLException("getInt not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE, value, columnInfo);
        return (int)value;
    }

    @Override
    public long getInternalLong(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0L;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2});
                if (unsignedValue.compareTo(new BigInteger(String.valueOf(Long.MAX_VALUE))) > 0) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + unsignedValue + " is not in Long range", "22003", 1264);
                }
                return unsignedValue.longValue();
            }
            case FLOAT: {
                Float floatValue = Float.valueOf(this.getInternalFloat(columnInfo));
                if (floatValue.compareTo(Float.valueOf(9.223372E18f)) >= 1) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + floatValue + " is not in Long range", "22003", 1264);
                }
                return floatValue.longValue();
            }
            case DOUBLE: {
                Double doubleValue = this.getInternalDouble(columnInfo);
                if (doubleValue.compareTo(9.223372036854776E18) >= 1) {
                    throw new SQLException("Out of range value for column '" + columnInfo.getName() + "' : value " + doubleValue + " is not in Long range", "22003", 1264);
                }
                return doubleValue.longValue();
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, bigDecimal, columnInfo);
                return bigDecimal.longValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                return Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
            }
            default: {
                throw new SQLException("getLong not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Long.class, Long.MIN_VALUE, Long.MAX_VALUE, value, columnInfo);
        return value;
    }

    @Override
    public float getInternalFloat(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0.0f;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                long value2 = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return value2;
                }
                BigInteger unsignedValue = new BigInteger(1, new byte[]{(byte)(value2 >> 56), (byte)(value2 >> 48), (byte)(value2 >> 40), (byte)(value2 >> 32), (byte)(value2 >> 24), (byte)(value2 >> 16), (byte)(value2 >> 8), (byte)value2});
                return unsignedValue.floatValue();
            }
            case FLOAT: {
                int valueFloat = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                return Float.intBitsToFloat(valueFloat);
            }
            case DOUBLE: {
                return (float)this.getInternalDouble(columnInfo);
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                try {
                    return Float.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8)).floatValue();
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format for getFloat for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
            default: {
                throw new SQLException("getFloat not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
            }
        }
        try {
            return Float.valueOf(String.valueOf(value)).floatValue();
        }
        catch (NumberFormatException nfe) {
            SQLException sqlException = new SQLException("Incorrect format for getFloat for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
            sqlException.initCause(nfe);
            throw sqlException;
        }
    }

    @Override
    public double getInternalDouble(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return 0.0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit();
            }
            case TINYINT: {
                return this.getInternalTinyInt(columnInfo);
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt(columnInfo);
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt(columnInfo);
            }
            case BIGINT: {
                long valueLong = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return valueLong;
                }
                return new BigInteger(1, new byte[]{(byte)(valueLong >> 56), (byte)(valueLong >> 48), (byte)(valueLong >> 40), (byte)(valueLong >> 32), (byte)(valueLong >> 24), (byte)(valueLong >> 16), (byte)(valueLong >> 8), (byte)valueLong}).doubleValue();
            }
            case FLOAT: {
                return this.getInternalFloat(columnInfo);
            }
            case DOUBLE: {
                long valueDouble = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                return Double.longBitsToDouble(valueDouble);
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                try {
                    return Double.valueOf(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                }
                catch (NumberFormatException nfe) {
                    SQLException sqlException = new SQLException("Incorrect format for getDouble for data field with type " + columnInfo.getColumnType().getJavaTypeName(), "22003", 1264);
                    sqlException.initCause(nfe);
                    throw sqlException;
                }
            }
        }
        throw new SQLException("getDouble not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
    }

    @Override
    public BigDecimal getInternalBigDecimal(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigDecimal.valueOf(this.parseBit());
            }
            case TINYINT: {
                return BigDecimal.valueOf(this.getInternalTinyInt(columnInfo));
            }
            case SMALLINT: 
            case YEAR: {
                return BigDecimal.valueOf(this.getInternalSmallInt(columnInfo));
            }
            case INTEGER: 
            case MEDIUMINT: {
                return BigDecimal.valueOf(this.getInternalMediumInt(columnInfo));
            }
            case BIGINT: {
                long value = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return new BigDecimal(String.valueOf(BigInteger.valueOf(value))).setScale(columnInfo.getDecimals());
                }
                return new BigDecimal(String.valueOf(new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value}))).setScale(columnInfo.getDecimals());
            }
            case FLOAT: {
                return BigDecimal.valueOf(this.getInternalFloat(columnInfo));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(this.getInternalDouble(columnInfo));
            }
            case STRING: 
            case DECIMAL: 
            case OLDDECIMAL: 
            case VARSTRING: 
            case VARCHAR: {
                return new BigDecimal(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
            }
        }
        throw new SQLException("getBigDecimal not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
    }

    @Override
    public Date getInternalDate(ColumnInformation columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp timestamp = this.getInternalTimestamp(columnInfo, cal, timeZone);
                return timestamp == null ? null : new Date(timestamp.getTime());
            }
            case TIME: {
                throw new SQLException("Cannot read Date using a Types.TIME field");
            }
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
        if (this.length == 2 && columnInfo.getLength() == 2L) {
            year = year <= 69 ? (year += 2000) : (year += 1900);
        }
        byte month = 1;
        byte day = 1;
        if (this.length >= 4) {
            month = this.buf[this.pos + 2];
            day = this.buf[this.pos + 3];
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date dt = new Date(calendar.getTimeInMillis());
        return dt;
    }

    @Override
    public Time getInternalTime(ColumnInformation columnInfo, Calendar cal, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case TIMESTAMP: 
            case DATETIME: {
                Timestamp ts = this.getInternalTimestamp(columnInfo, cal, timeZone);
                return ts == null ? null : new Time(ts.getTime());
            }
            case DATE: {
                throw new SQLException("Cannot read Time using a Types.DATE field");
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int day = 0;
        byte hour = 0;
        byte minutes = 0;
        int seconds = 0;
        boolean negate = false;
        if (this.length > 0) {
            boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
        }
        if (this.length > 4) {
            day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
        }
        if (this.length > 7) {
            hour = this.buf[this.pos + 5];
            minutes = this.buf[this.pos + 6];
            seconds = this.buf[this.pos + 7];
        }
        calendar.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
        int nanoseconds = 0;
        if (this.length > 8) {
            nanoseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
        }
        calendar.set(14, nanoseconds / 1000);
        return new Time(calendar.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getInternalTimestamp(ColumnInformation columnInfo, Calendar userCalendar, TimeZone timeZone) throws SQLException {
        Timestamp tt;
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        int day = 0;
        byte hour = 0;
        byte minutes = 0;
        byte seconds = 0;
        int microseconds = 0;
        if (columnInfo.getColumnType() == ColumnType.TIME) {
            Timestamp tt2;
            Calendar calendar = userCalendar != null ? userCalendar : Calendar.getInstance();
            boolean negate = false;
            if (this.length > 0) {
                boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
            }
            if (this.length > 4) {
                day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
            }
            if (this.length > 7) {
                hour = this.buf[this.pos + 5];
                minutes = this.buf[this.pos + 6];
                seconds = this.buf[this.pos + 7];
            }
            if (this.length > 8) {
                microseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
            }
            Calendar calendar2 = calendar;
            synchronized (calendar2) {
                calendar.clear();
                calendar.set(1970, 0, (negate ? -1 : 1) * day + 1, (negate ? -1 : 1) * hour, minutes, seconds);
                tt2 = new Timestamp(calendar.getTimeInMillis());
            }
            tt2.setNanos(microseconds * 1000);
            return tt2;
        }
        int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
        byte month = this.buf[this.pos + 2];
        day = this.buf[this.pos + 3];
        if (this.length > 4) {
            hour = this.buf[this.pos + 4];
            minutes = this.buf[this.pos + 5];
            seconds = this.buf[this.pos + 6];
            if (this.length > 7) {
                microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
            }
        }
        Calendar calendar = userCalendar != null ? userCalendar : (columnInfo.getColumnType().getSqlType() == 93 ? Calendar.getInstance(timeZone) : Calendar.getInstance());
        Calendar calendar3 = calendar;
        synchronized (calendar3) {
            calendar.clear();
            calendar.set(year, month - 1, day, hour, minutes, seconds);
            tt = new Timestamp(calendar.getTimeInMillis());
        }
        tt.setNanos(microseconds * 1000);
        return tt;
    }

    @Override
    public Object getInternalObject(ColumnInformation columnInfo, int dataTypeMappingFlags, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                if (columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                byte[] dataBit = new byte[this.length];
                System.arraycopy(this.buf, this.pos, dataBit, 0, this.length);
                return dataBit;
            }
            case TINYINT: {
                if (this.options.tinyInt1isBit && columnInfo.getLength() == 1L) {
                    return this.buf[this.pos] != 0;
                }
                return this.getInternalInt(columnInfo);
            }
            case INTEGER: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalLong(columnInfo);
                }
                return this.getInternalInt(columnInfo);
            }
            case BIGINT: {
                if (!columnInfo.isSigned()) {
                    return this.getInternalBigInteger(columnInfo);
                }
                return this.getInternalLong(columnInfo);
            }
            case DOUBLE: {
                return this.getInternalDouble(columnInfo);
            }
            case VARCHAR: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, data, 0, this.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case TIMESTAMP: 
            case DATETIME: {
                return this.getInternalTimestamp(columnInfo, null, timeZone);
            }
            case DATE: {
                return this.getInternalDate(columnInfo, null, timeZone);
            }
            case DECIMAL: {
                return this.getInternalBigDecimal(columnInfo);
            }
            case BLOB: 
            case LONGBLOB: 
            case MEDIUMBLOB: 
            case TINYBLOB: {
                byte[] dataBlob = new byte[this.getLengthMaxFieldSize()];
                System.arraycopy(this.buf, this.pos, dataBlob, 0, this.getLengthMaxFieldSize());
                return dataBlob;
            }
            case NULL: {
                return null;
            }
            case YEAR: {
                if ((dataTypeMappingFlags & 2) != 0) {
                    return this.getInternalDate(columnInfo, null, timeZone);
                }
                return this.getInternalShort(columnInfo);
            }
            case MEDIUMINT: 
            case SMALLINT: {
                return this.getInternalInt(columnInfo);
            }
            case FLOAT: {
                return Float.valueOf(this.getInternalFloat(columnInfo));
            }
            case TIME: {
                return this.getInternalTime(columnInfo, null, timeZone);
            }
            case STRING: 
            case VARSTRING: {
                if (columnInfo.isBinary()) {
                    byte[] data = new byte[this.getLengthMaxFieldSize()];
                    System.arraycopy(this.buf, this.pos, data, 0, this.getLengthMaxFieldSize());
                    return data;
                }
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case OLDDECIMAL: {
                return this.getInternalString(columnInfo, null, timeZone);
            }
            case GEOMETRY: {
                byte[] data = new byte[this.length];
                System.arraycopy(this.buf, this.pos, data, 0, this.length);
                return data;
            }
            case ENUM: {
                break;
            }
            case NEWDATE: {
                break;
            }
            case SET: {
                break;
            }
        }
        throw ExceptionMapper.getFeatureNotSupportedException("Type '" + columnInfo.getColumnType().getTypeName() + "' is not supported");
    }

    @Override
    public boolean getInternalBoolean(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return false;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return this.parseBit() != 0L;
            }
            case TINYINT: {
                return this.getInternalTinyInt(columnInfo) != 0;
            }
            case SMALLINT: 
            case YEAR: {
                return this.getInternalSmallInt(columnInfo) != 0;
            }
            case INTEGER: 
            case MEDIUMINT: {
                return this.getInternalMediumInt(columnInfo) != 0L;
            }
            case BIGINT: {
                return this.getInternalLong(columnInfo) != 0L;
            }
            case FLOAT: {
                return this.getInternalFloat(columnInfo) != 0.0f;
            }
            case DOUBLE: {
                return this.getInternalDouble(columnInfo) != 0.0;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                return this.getInternalBigDecimal(columnInfo).longValue() != 0L;
            }
        }
        String rawVal = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        return !"false".equals(rawVal) && !"0".equals(rawVal);
    }

    @Override
    public byte getInternalByte(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                value = this.parseBit();
                break;
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = this.getInternalSmallInt(columnInfo);
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                value = this.getInternalLong(columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getInternalFloat(columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getInternalDouble(columnInfo);
                break;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Byte.class, -128L, 127L, bigDecimal, columnInfo);
                return bigDecimal.byteValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                value = Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new SQLException("getByte not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Byte.class, -128L, 127L, value, columnInfo);
        return (byte)value;
    }

    @Override
    public short getInternalShort(ColumnInformation columnInfo) throws SQLException {
        long value;
        if (this.lastValueWasNull()) {
            return 0;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                value = this.parseBit();
                break;
            }
            case TINYINT: {
                value = this.getInternalTinyInt(columnInfo);
                break;
            }
            case SMALLINT: 
            case YEAR: {
                value = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8);
                if (columnInfo.isSigned()) {
                    return (short)value;
                }
                value &= 0xFFFFL;
                break;
            }
            case INTEGER: 
            case MEDIUMINT: {
                value = this.getInternalMediumInt(columnInfo);
                break;
            }
            case BIGINT: {
                value = this.getInternalLong(columnInfo);
                break;
            }
            case FLOAT: {
                value = (long)this.getInternalFloat(columnInfo);
                break;
            }
            case DOUBLE: {
                value = (long)this.getInternalDouble(columnInfo);
                break;
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                BigDecimal bigDecimal = this.getInternalBigDecimal(columnInfo);
                this.rangeCheck(Short.class, -32768L, 32767L, bigDecimal, columnInfo);
                return bigDecimal.shortValue();
            }
            case STRING: 
            case VARSTRING: 
            case VARCHAR: {
                value = Long.parseLong(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
                break;
            }
            default: {
                throw new SQLException("getShort not available for data field type " + columnInfo.getColumnType().getJavaTypeName());
            }
        }
        this.rangeCheck(Short.class, -32768L, 32767L, value, columnInfo);
        return (short)value;
    }

    @Override
    public String getInternalTimeString(ColumnInformation columnInfo) {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            if (columnInfo.getDecimals() == 0) {
                return "00:00:00";
            }
            StringBuilder value = new StringBuilder("00:00:00.");
            int decimal = columnInfo.getDecimals();
            while (decimal-- > 0) {
                value.append("0");
            }
            return value.toString();
        }
        String rawValue = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
        if ("0000-00-00".equals(rawValue)) {
            return null;
        }
        byte hour = this.buf[this.pos + 5];
        int day = this.buf[this.pos + 1] & 0xFF | (this.buf[this.pos + 2] & 0xFF) << 8 | (this.buf[this.pos + 3] & 0xFF) << 16 | (this.buf[this.pos + 4] & 0xFF) << 24;
        int timeHour = hour + day * 24;
        String hourString = timeHour < 10 ? "0" + timeHour : Integer.toString(timeHour);
        byte minutes = this.buf[this.pos + 6];
        String minuteString = minutes < 10 ? "0" + minutes : Integer.toString(minutes);
        byte seconds = this.buf[this.pos + 7];
        String secondString = seconds < 10 ? "0" + seconds : Integer.toString(seconds);
        int microseconds = 0;
        if (this.length > 8) {
            microseconds = this.buf[this.pos + 8] & 0xFF | (this.buf[this.pos + 9] & 0xFF) << 8 | (this.buf[this.pos + 10] & 0xFF) << 16 | (this.buf[this.pos + 11] & 0xFF) << 24;
        }
        StringBuilder microsecondString = new StringBuilder(Integer.toString(microseconds));
        while (microsecondString.length() < 6) {
            microsecondString.insert(0, "0");
        }
        boolean negative = this.buf[this.pos] == 1;
        return (negative ? "-" : "") + hourString + ":" + minuteString + ":" + secondString + "." + microsecondString;
    }

    @Override
    public BigInteger getInternalBigInteger(ColumnInformation columnInfo) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        switch (columnInfo.getColumnType()) {
            case BIT: {
                return BigInteger.valueOf(this.buf[this.pos]);
            }
            case TINYINT: {
                return BigInteger.valueOf(columnInfo.isSigned() ? this.buf[this.pos] : this.buf[this.pos] & 0xFF);
            }
            case SMALLINT: 
            case YEAR: {
                int valueShort = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                return BigInteger.valueOf(columnInfo.isSigned() ? valueShort : valueShort & 0xFFFF);
            }
            case INTEGER: 
            case MEDIUMINT: {
                int valueInt = (this.buf[this.pos] & 0xFF) + ((this.buf[this.pos + 1] & 0xFF) << 8) + ((this.buf[this.pos + 2] & 0xFF) << 16) + ((this.buf[this.pos + 3] & 0xFF) << 24);
                return BigInteger.valueOf(columnInfo.isSigned() ? (long)valueInt : (valueInt >= 0 ? (long)valueInt : (long)valueInt & 0xFFFFFFFFL));
            }
            case BIGINT: {
                long value = (long)(this.buf[this.pos] & 0xFF) + ((long)(this.buf[this.pos + 1] & 0xFF) << 8) + ((long)(this.buf[this.pos + 2] & 0xFF) << 16) + ((long)(this.buf[this.pos + 3] & 0xFF) << 24) + ((long)(this.buf[this.pos + 4] & 0xFF) << 32) + ((long)(this.buf[this.pos + 5] & 0xFF) << 40) + ((long)(this.buf[this.pos + 6] & 0xFF) << 48) + ((long)(this.buf[this.pos + 7] & 0xFF) << 56);
                if (columnInfo.isSigned()) {
                    return BigInteger.valueOf(value);
                }
                return new BigInteger(1, new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value});
            }
            case FLOAT: {
                return BigInteger.valueOf((long)this.getInternalFloat(columnInfo));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)this.getInternalDouble(columnInfo));
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                return BigInteger.valueOf(this.getInternalBigDecimal(columnInfo).longValue());
            }
        }
        return new BigInteger(new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8));
    }

    @Override
    public ZonedDateTime getInternalZonedDateTime(ColumnInformation columnInfo, Class clazz, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 93: {
                int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte month = this.buf[this.pos + 2];
                byte day = this.buf[this.pos + 3];
                byte hour = 0;
                int minutes = 0;
                int seconds = 0;
                int microseconds = 0;
                if (this.length > 4) {
                    hour = this.buf[this.pos + 4];
                    minutes = this.buf[this.pos + 5];
                    seconds = this.buf[this.pos + 6];
                    if (this.length > 7) {
                        microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                    }
                }
                return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, timeZone.toZoneId());
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                if (raw.startsWith("0000-00-00 00:00:00")) {
                    return null;
                }
                try {
                    return ZonedDateTime.parse(raw, TEXT_ZONED_DATE_TIME);
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as ZonedDateTime. time must have \"yyyy-MM-dd[T/ ]HH:mm:ss[.S]\" with offset and timezone format (example : '2011-12-03 10:15:30+01:00[Europe/Paris]')");
                }
            }
        }
        throw new SQLException("Cannot read " + clazz.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public OffsetTime getInternalOffsetTime(ColumnInformation columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        ZoneId zoneId = timeZone.toZoneId().normalized();
        if (ZoneOffset.class.isInstance(zoneId)) {
            ZoneOffset zoneOffset = (ZoneOffset)ZoneOffset.class.cast(zoneId);
            int day = 0;
            byte hour = 0;
            byte minutes = 0;
            int seconds = 0;
            int microseconds = 0;
            switch (columnInfo.getColumnType().getSqlType()) {
                case 93: {
                    int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                    byte month = this.buf[this.pos + 2];
                    day = this.buf[this.pos + 3];
                    if (this.length > 4) {
                        hour = this.buf[this.pos + 4];
                        minutes = this.buf[this.pos + 5];
                        seconds = this.buf[this.pos + 6];
                        if (this.length > 7) {
                            microseconds = (this.buf[this.pos + 7] & 0xFF) + ((this.buf[this.pos + 8] & 0xFF) << 8) + ((this.buf[this.pos + 9] & 0xFF) << 16) + ((this.buf[this.pos + 10] & 0xFF) << 24);
                        }
                    }
                    return ZonedDateTime.of(year, month, day, hour, minutes, seconds, microseconds * 1000, zoneOffset).toOffsetDateTime().toOffsetTime();
                }
                case 92: {
                    boolean negate;
                    boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
                    if (this.length > 4) {
                        day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                    }
                    if (this.length > 7) {
                        hour = this.buf[this.pos + 5];
                        minutes = this.buf[this.pos + 6];
                        seconds = this.buf[this.pos + 7];
                    }
                    if (this.length > 8) {
                        microseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                    }
                    return OffsetTime.of((negate ? -1 : 1) * (day * 24 + hour), minutes, seconds, microseconds * 1000, zoneOffset);
                }
                case -1: 
                case 1: 
                case 12: {
                    String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                    try {
                        return OffsetTime.parse(raw, DateTimeFormatter.ISO_OFFSET_TIME);
                    }
                    catch (DateTimeParseException dateParserEx) {
                        throw new SQLException(raw + " cannot be parse as OffsetTime (format is \"HH:mm:ss[.S]\" with offset for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                    }
                }
            }
            throw new SQLException("Cannot read " + OffsetTime.class.getName() + " using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
        }
        if (this.options.useLegacyDatetimeCode) {
            throw new SQLException("Cannot return an OffsetTime for a TIME field when default timezone is '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
        }
        throw new SQLException("Cannot return an OffsetTime for a TIME field when server timezone '" + zoneId + "' (only possible for time-zone offset from Greenwich/UTC, such as +02:00)");
    }

    @Override
    public LocalTime getInternalLocalTime(ColumnInformation columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 92: {
                boolean negate;
                int day = 0;
                byte hour = 0;
                byte minutes = 0;
                int seconds = 0;
                int microseconds = 0;
                boolean bl = negate = (this.buf[this.pos] & 0xFF) == 1;
                if (this.length > 4) {
                    day = (this.buf[this.pos + 1] & 0xFF) + ((this.buf[this.pos + 2] & 0xFF) << 8) + ((this.buf[this.pos + 3] & 0xFF) << 16) + ((this.buf[this.pos + 4] & 0xFF) << 24);
                }
                if (this.length > 7) {
                    hour = this.buf[this.pos + 5];
                    minutes = this.buf[this.pos + 6];
                    seconds = this.buf[this.pos + 7];
                }
                if (this.length > 8) {
                    microseconds = (this.buf[this.pos + 8] & 0xFF) + ((this.buf[this.pos + 9] & 0xFF) << 8) + ((this.buf[this.pos + 10] & 0xFF) << 16) + ((this.buf[this.pos + 11] & 0xFF) << 24);
                }
                return LocalTime.of((negate ? -1 : 1) * (day * 24 + hour), minutes, seconds, microseconds * 1000);
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                try {
                    return LocalTime.parse(raw, DateTimeFormatter.ISO_LOCAL_TIME.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalTime (format is \"HH:mm:ss[.S]\" for data type \"" + (Object)((Object)columnInfo.getColumnType()) + "\")");
                }
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalTime.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalTime();
            }
        }
        throw new SQLException("Cannot read LocalTime using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public LocalDate getInternalLocalDate(ColumnInformation columnInfo, TimeZone timeZone) throws SQLException {
        if (this.lastValueWasNull()) {
            return null;
        }
        if (this.length == 0) {
            this.lastValueNull |= 1;
            return null;
        }
        switch (columnInfo.getColumnType().getSqlType()) {
            case 91: {
                int year = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
                byte month = this.buf[this.pos + 2];
                byte day = this.buf[this.pos + 3];
                return LocalDate.of(year, month, (int)day);
            }
            case 93: {
                ZonedDateTime zonedDateTime = this.getInternalZonedDateTime(columnInfo, LocalDate.class, timeZone);
                return zonedDateTime == null ? null : zonedDateTime.withZoneSameInstant(ZoneId.systemDefault()).toLocalDate();
            }
            case -1: 
            case 1: 
            case 12: {
                String raw = new String(this.buf, this.pos, this.length, StandardCharsets.UTF_8);
                if (raw.startsWith("0000-00-00")) {
                    return null;
                }
                try {
                    return LocalDate.parse(raw, DateTimeFormatter.ISO_LOCAL_DATE.withZone(timeZone.toZoneId()));
                }
                catch (DateTimeParseException dateParserEx) {
                    throw new SQLException(raw + " cannot be parse as LocalDate. time must have \"yyyy-MM-dd\" format");
                }
            }
        }
        throw new SQLException("Cannot read LocalDate using a " + columnInfo.getColumnType().getJavaTypeName() + " field");
    }

    @Override
    public boolean isBinaryEncoded() {
        return true;
    }
}

