/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.dao;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import me.lucko.helper.sql.external.mariadb.jdbc.internal.com.read.resultset.ColumnInformation;

public class ColumnNameMap {
    private Map<String, Integer> originalMap;
    private Map<String, Integer> aliasMap;
    private final ColumnInformation[] columnInfo;

    public ColumnNameMap(ColumnInformation[] columnInformations) {
        this.columnInfo = columnInformations;
    }

    public int getIndex(String name) throws SQLException {
        Integer res;
        if (name == null) {
            throw new SQLException("Column name cannot be null");
        }
        String lowerName = name.toLowerCase();
        if (this.aliasMap == null) {
            this.aliasMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnAlias = ci.getName();
                if (columnAlias != null && !columnAlias.isEmpty()) {
                    columnAlias = columnAlias.toLowerCase();
                    this.aliasMap.putIfAbsent(columnAlias, counter);
                    String tableName = ci.getTable();
                    if (tableName != null && !tableName.isEmpty()) {
                        this.aliasMap.putIfAbsent(tableName.toLowerCase() + "." + columnAlias, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.aliasMap.get(lowerName)) != null) {
            return res;
        }
        if (this.originalMap == null) {
            this.originalMap = new HashMap<String, Integer>();
            int counter = 0;
            for (ColumnInformation ci : this.columnInfo) {
                String columnRealName = ci.getOriginalName();
                if (columnRealName != null && !columnRealName.isEmpty()) {
                    columnRealName = columnRealName.toLowerCase();
                    this.originalMap.putIfAbsent(columnRealName, counter);
                    String tableName = ci.getOriginalTable();
                    if (tableName != null && !tableName.isEmpty()) {
                        this.originalMap.putIfAbsent(tableName.toLowerCase() + "." + columnRealName, counter);
                    }
                }
                ++counter;
            }
        }
        if ((res = this.originalMap.get(lowerName)) == null) {
            throw new SQLException("No such column :" + name);
        }
        return res;
    }
}

