/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js.script;

import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.js.script.Script;
import me.lucko.helper.js.script.ScriptLogger;

public class SimpleScriptLogger
implements ScriptLogger {
    private final Script script;

    public SimpleScriptLogger(@Nonnull Script script) {
        this.script = script;
    }

    @Override
    public void info(Object ... message) {
        this.getLogger().info("[" + this.script.getName() + "]" + SimpleScriptLogger.format(message));
    }

    @Override
    public void warn(Object ... message) {
        this.getLogger().warning("[" + this.script.getName() + "]" + SimpleScriptLogger.format(message));
    }

    @Override
    public void error(Object ... message) {
        this.getLogger().severe("[" + this.script.getName() + "]" + SimpleScriptLogger.format(message));
    }

    private static String format(@Nullable Object[] message) {
        if (message == null || message.length == 0) {
            return " ";
        }
        if (message.length == 1) {
            return " " + String.valueOf(message[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : message) {
            sb.append(" ").append(String.valueOf(o));
        }
        return sb.toString();
    }

    private Logger getLogger() {
        return this.script.getBindings().getPlugin().getPluginLogger();
    }
}

