/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js.loader;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.js.loader.ScriptRegistry;
import me.lucko.helper.js.script.Script;

class SimpleScriptRegistry
implements ScriptRegistry {
    private Map<Path, Script> scripts = new HashMap<Path, Script>();

    SimpleScriptRegistry() {
    }

    @Override
    public void register(@Nonnull Script script) {
        this.scripts.put(script.getPath(), script);
    }

    @Override
    public void unregister(@Nonnull Script script) {
        this.scripts.remove(script.getPath());
    }

    @Override
    @Nullable
    public Script getScript(@Nonnull Path path) {
        return this.scripts.get(path);
    }

    @Override
    @Nonnull
    public Map<Path, Script> getAll() {
        return Collections.unmodifiableMap(this.scripts);
    }

    public boolean terminate() {
        for (Script script : this.scripts.values()) {
            script.terminate();
        }
        return true;
    }
}

