/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js.loader;

import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import me.lucko.helper.js.loader.ScriptLoader;

public class DelegateScriptLoader
implements ScriptLoader {
    private ScriptLoader parent;
    private Set<String> paths = new HashSet<String>();

    public DelegateScriptLoader(@Nonnull ScriptLoader parent) {
        this.parent = parent;
    }

    @Override
    public void watchAll(@Nonnull Collection<String> paths) {
        for (String s : paths) {
            if (this.paths.contains(s)) continue;
            this.paths.add(s);
            this.parent.watch(s);
        }
    }

    @Override
    public void unwatchAll(@Nonnull Collection<String> paths) {
        for (String s : paths) {
            if (!this.paths.contains(s)) continue;
            this.paths.remove(s);
            this.parent.unwatch(s);
        }
    }

    @Override
    public Path getDirectory() {
        return this.parent.getDirectory();
    }

    public boolean terminate() {
        this.parent.unwatchAll(this.paths);
        this.paths.clear();
        return true;
    }
}

