/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js.exports;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.lucko.helper.js.exports.ScriptExport;
import me.lucko.helper.js.exports.ScriptExportRegistry;
import me.lucko.helper.js.exports.SimpleScriptExport;

class SimpleScriptExportRegistry
implements ScriptExportRegistry,
Function<String, ScriptExport<?>> {
    private final Map<String, ScriptExport<?>> handles = new ConcurrentHashMap();

    SimpleScriptExportRegistry() {
    }

    @Override
    public ScriptExport<?> apply(String s) {
        return new SimpleScriptExport(s);
    }

    @Override
    @Nonnull
    public <T> ScriptExport<T> handle(@Nonnull String key) {
        return this.handles.computeIfAbsent(key.toLowerCase(), this);
    }

    @Override
    public boolean has(@Nonnull String key) {
        ScriptExport<?> handle = this.handles.get(key.toLowerCase());
        return handle != null && handle.hasValue();
    }

    @Override
    public void remove(@Nonnull String key) {
        this.handles.remove(key.toLowerCase());
    }

    @Override
    @Nonnull
    public Collection<ScriptExport<?>> getExports() {
        return Collections.unmodifiableCollection(this.handles.values());
    }
}

