/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js.exports;

import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.lucko.helper.js.exports.ScriptExport;
import me.lucko.helper.js.exports.SimpleScriptExportRegistry;

public interface ScriptExportRegistry {
    @Nonnull
    public static ScriptExportRegistry create() {
        return new SimpleScriptExportRegistry();
    }

    @Nonnull
    public <T> ScriptExport<T> handle(@Nonnull String var1);

    @Nonnull
    default public <T> ScriptExport<T> handle(@Nonnull String key, T defaultValue) {
        ScriptExport<T> handle = this.handle(key);
        return handle.setIfAbsent(defaultValue);
    }

    @Nonnull
    default public <T> ScriptExport<T> handle(@Nonnull String key, Supplier<T> defaultValue) {
        ScriptExport<T> handle = this.handle(key);
        return handle.setIfAbsent(defaultValue);
    }

    @Nullable
    default public <T> T get(@Nonnull String key) {
        ScriptExport<T> handle = this.handle(key);
        return handle.get();
    }

    default public <T> T get(@Nonnull String key, T other) {
        ScriptExport<T> handle = this.handle(key);
        return handle.get(other);
    }

    default public <T> T get(@Nonnull String key, @Nonnull Supplier<T> other) {
        ScriptExport<T> handle = this.handle(key);
        return handle.get(other);
    }

    @Nonnull
    default public <T> ScriptExport<T> set(@Nonnull String key, T value) {
        ScriptExport<T> handle = this.handle(key);
        return handle.set(value);
    }

    public boolean has(@Nonnull String var1);

    public void remove(@Nonnull String var1);

    @Nonnull
    public Collection<ScriptExport<?>> getExports();
}

