/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js.bindings;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.script.Bindings;

public final class GeneralScriptBindings {
    private static final Supplier<ArrayList> ARRAY_LIST = GeneralScriptBindings::newArrayList;
    private static final Supplier<LinkedList> LINKED_LIST = GeneralScriptBindings::newLinkedList;
    private static final Supplier<HashSet> HASH_SET = GeneralScriptBindings::newHashSet;
    private static final Supplier<HashMap> HASH_MAP = GeneralScriptBindings::newHashMap;
    private static final Supplier<CopyOnWriteArrayList> COPY_ON_WRITE_ARRAY_LIST = GeneralScriptBindings::newCopyOnWriteArrayList;
    private static final Supplier<Set> CONCURRENT_HASH_SET = GeneralScriptBindings::newConcurrentHashSet;
    private static final Supplier<ConcurrentHashMap> CONCURRENT_HASH_MAP = GeneralScriptBindings::newConcurrentHashMap;
    private static final Function<Object[], ArrayList> LIST_OF = GeneralScriptBindings::listOf;
    private static final Function<Object[], HashSet> SET_OF = GeneralScriptBindings::setOf;
    private static final Function<Object[], ImmutableList> IMMUTABLE_LIST_OF = GeneralScriptBindings::immutableListOf;
    private static final Function<Object[], ImmutableSet> IMMUTABLE_SET_OF = GeneralScriptBindings::immutableSetOf;
    private static final Function<String, UUID> PARSE_UUID = GeneralScriptBindings::parseUuid;

    public static void appendTo(Bindings bindings) {
        bindings.put("newArrayList", (Object)ARRAY_LIST);
        bindings.put("newLinkedList", (Object)LINKED_LIST);
        bindings.put("newHashSet", (Object)HASH_SET);
        bindings.put("newHashMap", (Object)HASH_MAP);
        bindings.put("newCopyOnWriteArrayList", (Object)COPY_ON_WRITE_ARRAY_LIST);
        bindings.put("newConcurrentHashSet", (Object)CONCURRENT_HASH_SET);
        bindings.put("newConcurrentHashMap", (Object)CONCURRENT_HASH_MAP);
        bindings.put("listOf", (Object)LIST_OF);
        bindings.put("setOf", (Object)SET_OF);
        bindings.put("immutableListOf", (Object)IMMUTABLE_LIST_OF);
        bindings.put("immutableSetOf", (Object)IMMUTABLE_SET_OF);
        bindings.put("parseUuid", (Object)PARSE_UUID);
    }

    private static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    private static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    private static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    private static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    private static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    private static <T> Set<T> newConcurrentHashSet() {
        return ConcurrentHashMap.newKeySet();
    }

    private static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    private static ArrayList listOf(Object[] objects) {
        return new ArrayList<Object>(Arrays.asList(objects));
    }

    private static HashSet setOf(Object[] objects) {
        return new HashSet<Object>(Arrays.asList(objects));
    }

    private static ImmutableList immutableListOf(Object[] objects) {
        return ImmutableList.copyOf((Object[])objects);
    }

    private static ImmutableSet immutableSetOf(Object[] objects) {
        return ImmutableSet.copyOf((Object[])objects);
    }

    private static UUID parseUuid(String s) {
        try {
            return UUID.fromString(s);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private GeneralScriptBindings() {
        throw new UnsupportedOperationException("This class cannot be instantiated");
    }
}

