/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import me.lucko.helper.Scheduler;
import me.lucko.helper.js.HelperJsPlugin;
import me.lucko.helper.js.HelperScript;
import me.lucko.helper.js.bindings.SystemScriptBindings;
import me.lucko.helper.js.loader.ScriptRegistry;
import me.lucko.helper.js.loader.SystemScriptLoader;
import me.lucko.helper.js.script.Script;
import me.lucko.helper.terminable.Terminables;

public class HelperScriptLoader
implements SystemScriptLoader {
    private final HelperJsPlugin plugin;
    private final SystemScriptBindings bindings;
    private final Path scriptDirectory;
    private final WatchService watchService;
    private WatchKey watchKey;
    private List<Path> files = new ArrayList<Path>();
    private final ScriptRegistry registry = ScriptRegistry.create();
    private final ReentrantLock lock = new ReentrantLock();

    public HelperScriptLoader(HelperJsPlugin plugin, SystemScriptBindings bindings, Path scriptDirectory) {
        this.plugin = plugin;
        this.bindings = bindings;
        this.scriptDirectory = scriptDirectory;
        try {
            this.watchService = scriptDirectory.getFileSystem().newWatchService();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            this.watchKey = this.scriptDirectory.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watchAll(@Nonnull Collection<String> paths) {
        this.lock.lock();
        try {
            for (String s : paths) {
                this.files.add(Paths.get(s, new String[0]));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unwatchAll(@Nonnull Collection<String> paths) {
        this.lock.lock();
        try {
            for (String s : paths) {
                this.files.remove(Paths.get(s, new String[0]));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void preload() {
        int filesLength;
        do {
            filesLength = this.files.size();
            this.run();
        } while (filesLength != this.files.size());
    }

    @Override
    public void run() {
        this.lock.lock();
        try {
            this.reload();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void reload() {
        Script script;
        LinkedHashSet<Path> toReload = new LinkedHashSet<Path>();
        LinkedHashSet<Path> toLoad = new LinkedHashSet<Path>();
        LinkedHashSet<Script> toUnload = new LinkedHashSet<Script>();
        for (Path path : this.files) {
            Script script2 = this.registry.getScript(path);
            if (this.scriptDirectory.resolve(path).toFile().exists()) {
                if (script2 != null) continue;
                toLoad.add(path);
                continue;
            }
            if (script2 == null) continue;
            toUnload.add(script2);
        }
        for (Map.Entry entry : this.registry.getAll().entrySet()) {
            if (this.files.contains(entry.getKey())) continue;
            toUnload.add((Script)entry.getValue());
        }
        HashSet<Path> tryUnload = new HashSet<Path>();
        List<WatchEvent<?>> list = this.watchKey.pollEvents();
        for (WatchEvent watchEvent : list) {
            Path path = (Path)watchEvent.context();
            if (path == null || toLoad.contains(path) || toUnload.stream().anyMatch(s -> s.getPath().equals(context))) continue;
            if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                tryUnload.add(path);
                continue;
            }
            script = this.registry.getScript(path);
            if (script == null) {
                if (this.files.contains(path)) {
                    toLoad.add(path);
                    continue;
                }
                toReload.add(path);
                continue;
            }
            toReload.add(script.getPath());
        }
        boolean valid = this.watchKey.reset();
        if (!valid) {
            new RuntimeException("WatchKey no longer valid: " + list.toString()).printStackTrace();
            try {
                this.watchKey = this.scriptDirectory.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        for (Path path : tryUnload) {
            script = this.registry.getScript(path);
            if (script == null || toLoad.contains(path) || toReload.contains(path)) continue;
            toUnload.add(script);
        }
        LinkedHashSet<Path> linkedHashSet = new LinkedHashSet<Path>();
        for (Path p : toReload) {
            this.resolveDepends(linkedHashSet, p);
        }
        HashSet<Script> hashSet = new HashSet<Script>();
        HashSet<HelperScript> toRun = new HashSet<HelperScript>();
        for (Path path : linkedHashSet) {
            Script oldScript = this.registry.getScript(path);
            if (oldScript == null) continue;
            hashSet.add(oldScript);
            HelperScript newScript = new HelperScript(path, this, this.bindings);
            this.registry.register(newScript);
            toRun.add(newScript);
            this.plugin.getLogger().info("[LOADER] Reloaded script: " + HelperScriptLoader.pathToString(path));
        }
        for (Path path : toLoad) {
            if (this.registry.getScript(path) != null) continue;
            HelperScript script4 = new HelperScript(path, this, this.bindings);
            this.registry.register(script4);
            toRun.add(script4);
            this.plugin.getLogger().info("[LOADER] Loaded script: " + HelperScriptLoader.pathToString(path));
        }
        for (Script s2 : toUnload) {
            this.registry.unregister(s2);
            hashSet.add(s2);
            this.plugin.getLogger().info("[LOADER] Unloaded script: " + HelperScriptLoader.pathToString(s2.getPath()));
        }
        Scheduler.runSync(() -> {
            for (Script script : toRun) {
                try {
                    script.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Terminables.silentlyTerminate((Iterable)toTerminate);
        });
    }

    private void resolveDepends(Set<Path> accumulator, Path path) {
        if (!accumulator.add(path)) {
            return;
        }
        for (Script other : this.registry.getAll().values()) {
            if (!other.getDependencies().contains(path)) continue;
            this.resolveDepends(accumulator, other.getPath());
        }
    }

    @Override
    public Path getDirectory() {
        return this.scriptDirectory;
    }

    public boolean terminate() {
        this.registry.terminate();
        this.files.clear();
        return true;
    }

    private static String pathToString(Path path) {
        return path.toString().replace("\\", "/");
    }
}

