/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.script.Bindings;
import me.lucko.helper.js.HelperJsPlugin;
import me.lucko.helper.js.bindings.GeneralScriptBindings;
import me.lucko.helper.js.bindings.SystemScriptBindings;
import me.lucko.helper.js.exports.ScriptExportRegistry;
import me.lucko.helper.js.plugin.ScriptPlugin;
import me.lucko.helper.menu.scheme.MenuScheme;
import me.lucko.helper.menu.scheme.SchemeMapping;
import me.lucko.helper.metadata.MetadataKey;
import me.lucko.helper.utils.Color;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class HelperScriptBindings
implements SystemScriptBindings {
    private static final Method GET_CLASSLOADER_METHOD;
    private static final Method GET_PACKAGES_METHOD;
    private final ScriptPlugin plugin;
    private final ScriptExportRegistry exports;

    public HelperScriptBindings(HelperJsPlugin plugin) {
        this.plugin = plugin;
        this.exports = ScriptExportRegistry.create();
    }

    @Override
    @Nonnull
    public ScriptPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    @Nonnull
    public ScriptExportRegistry getExports() {
        return this.exports;
    }

    @Override
    public void appendTo(@Nonnull Bindings bindings) {
        bindings.put("exports", (Object)this.exports);
        bindings.put("server", (Object)Bukkit.getServer());
        bindings.put("plugin", (Object)this.plugin);
        bindings.put("services", (Object)Bukkit.getServicesManager());
        bindings.put("colorize", HelperScriptBindings::colorize);
        bindings.put("newMetadataKey", HelperScriptBindings::newMetadataKey);
        bindings.put("newScheme", HelperScriptBindings::newScheme);
        bindings.put("newScheme", HelperScriptBindings::newScheme);
        GeneralScriptBindings.appendTo(bindings);
        bindings.put("resolvePackageWildcard", HelperScriptBindings::resolvePackageWildcard);
    }

    private static String colorize(Object object) {
        return Color.colorize((String)object.toString());
    }

    private static <T> MetadataKey<T> newMetadataKey(Object id) {
        return MetadataKey.create((String)id.toString(), (TypeToken)new TypeToken<T>(){});
    }

    private static MenuScheme newScheme() {
        return new MenuScheme();
    }

    private static MenuScheme newScheme(SchemeMapping mapping) {
        return new MenuScheme(mapping);
    }

    private static List<String> resolvePackageWildcard(String name) {
        Set<String> allPackages;
        if (name.endsWith(".*")) {
            name = name.substring(0, name.length() - 2);
        }
        try {
            allPackages = HelperScriptBindings.getAllPackages();
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        HashSet<String> matches = new HashSet<String>();
        matches.add(name);
        for (String p : allPackages) {
            if (!p.startsWith(name)) continue;
            matches.add(p);
        }
        return new ArrayList<String>(matches);
    }

    private static Set<String> getAllPackages() throws Exception {
        TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (Plugin plugin : Bukkit.getServer().getPluginManager().getPlugins()) {
            ClassLoader classLoader = (ClassLoader)GET_CLASSLOADER_METHOD.invoke((Object)plugin, new Object[0]);
            classLoaders.add(classLoader);
        }
        classLoaders.add(ClassLoader.getSystemClassLoader());
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(Bukkit.getServer().getClass().getClassLoader());
        for (ClassLoader classLoader : classLoaders) {
            Package[] packages;
            for (Package p : packages = (Package[])GET_PACKAGES_METHOD.invoke((Object)classLoader, new Object[0])) {
                names.add(p.getName());
            }
        }
        return names;
    }

    static {
        Method getPackages;
        Method getClassLoader;
        try {
            getClassLoader = JavaPlugin.class.getDeclaredMethod("getClassLoader", new Class[0]);
            getClassLoader.setAccessible(true);
            getPackages = ClassLoader.class.getDeclaredMethod("getPackages", new Class[0]);
            getPackages.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        GET_CLASSLOADER_METHOD = getClassLoader;
        GET_PACKAGES_METHOD = getPackages;
    }
}

