/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.NashornScriptEngineFactory;
import me.lucko.helper.js.bindings.SystemScriptBindings;
import me.lucko.helper.js.loader.DelegateScriptLoader;
import me.lucko.helper.js.loader.ScriptLoader;
import me.lucko.helper.js.loader.SystemScriptLoader;
import me.lucko.helper.js.plugin.ScriptPlugin;
import me.lucko.helper.js.script.Script;
import me.lucko.helper.js.script.ScriptLogger;
import me.lucko.helper.js.script.SimpleScriptLogger;
import me.lucko.helper.terminable.registry.TerminableRegistry;

public class HelperScript
implements Script {
    private static ScriptEngine engine;
    private final String name;
    private final Path path;
    private final ScriptLoader loader;
    private final SystemScriptBindings systemBindings;
    private final ScriptLogger logger;
    private final TerminableRegistry terminableRegistry = TerminableRegistry.create();
    private final Set<Path> depends = new HashSet<Path>();

    private static synchronized ScriptEngine initEngine(ScriptPlugin plugin) {
        if (engine == null) {
            engine = new NashornScriptEngineFactory().getScriptEngine(plugin.getPluginClassLoader());
        }
        return engine;
    }

    public HelperScript(@Nonnull Path path, @Nonnull SystemScriptLoader loader, @Nonnull SystemScriptBindings systemBindings) {
        String name = path.getFileName().toString();
        this.name = name.endsWith(".js") ? name.substring(0, name.length() - 3) : name;
        this.path = path;
        this.loader = new DelegateScriptLoader(loader);
        this.systemBindings = systemBindings;
        this.logger = new SimpleScriptLogger(this);
        this.depends.add(this.path);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Override
    @Nonnull
    public SystemScriptBindings getBindings() {
        return this.systemBindings;
    }

    @Override
    @Nonnull
    public ScriptLogger getLogger() {
        return this.logger;
    }

    @Override
    public void run() {
        ScriptEngine engine = HelperScript.initEngine(this.systemBindings.getPlugin());
        try {
            Bindings bindings = engine.createBindings();
            bindings.put("loader", (Object)this.loader);
            bindings.put("registry", (Object)this.terminableRegistry);
            bindings.put("logger", (Object)this.logger);
            bindings.put("cwd", (Object)this.path.normalize().toString().replace("\\", "/"));
            bindings.put("rsd", (Object)(this.loader.getDirectory().normalize().toString().replace("\\", "/") + "/"));
            bindings.put("depend", this::depend);
            this.systemBindings.appendTo(bindings);
            SimpleScriptContext context = new SimpleScriptContext();
            context.setBindings(bindings, 100);
            engine.eval(this.systemBindings.getPlugin().getScriptHeader(), (ScriptContext)context);
            Path loadPath = this.loader.getDirectory().normalize().resolve(this.path);
            engine.eval("__load(\"" + loadPath.toString().replace("\\", "/") + "\");", (ScriptContext)context);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Set<Path> getDependencies() {
        return Collections.unmodifiableSet(this.depends);
    }

    @Override
    public void depend(@Nonnull String path) {
        this.depend(Paths.get(path, new String[0]));
    }

    @Override
    public void depend(@Nonnull Path path) {
        if (this.path.equals(path)) {
            return;
        }
        this.depends.add(path);
    }

    public boolean terminate() {
        this.loader.terminate();
        this.terminableRegistry.terminate();
        return true;
    }
}

