/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.js;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import me.lucko.helper.Scheduler;
import me.lucko.helper.js.HelperScriptBindings;
import me.lucko.helper.js.HelperScriptLoader;
import me.lucko.helper.js.loader.SystemScriptLoader;
import me.lucko.helper.js.plugin.ScriptPlugin;
import me.lucko.helper.js.utils.EnsureLoad;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import org.bukkit.configuration.file.YamlConfiguration;

public class HelperJsPlugin
extends ExtendedJavaPlugin
implements ScriptPlugin {
    private HelperScriptLoader loader;
    private String scriptHeader;

    protected void load() {
        EnsureLoad.ensure();
    }

    protected void enable() {
        InputStream headerResource = this.getResource("header.js");
        if (headerResource == null) {
            throw new RuntimeException("Unable to get resource 'header.js' from jar");
        }
        try {
            this.scriptHeader = CharStreams.toString((Readable)new InputStreamReader(headerResource, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred whilst reading header file", e);
        }
        YamlConfiguration config = this.loadConfig("config.yml");
        Path scriptDirectory = Paths.get(config.getString("script-directory"), new String[0]);
        if (!Files.isDirectory(scriptDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(scriptDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.getLogger().info("Using script directory: " + scriptDirectory.toString() + "(" + scriptDirectory.toAbsolutePath().toString() + ")");
        this.loader = new HelperScriptLoader(this, new HelperScriptBindings(this), scriptDirectory);
        this.loader.watch(config.getString("init-script", "init.js"));
        this.loader.preload();
        Scheduler.runTaskRepeatingAsync((Runnable)this.loader, (long)0L, (long)config.getLong("poll-interval", 20L));
    }

    @Override
    @Nonnull
    public SystemScriptLoader getScriptLoader() {
        return this.loader;
    }

    @Override
    @Nonnull
    public ClassLoader getPluginClassLoader() {
        return this.getClassLoader();
    }

    @Override
    @Nonnull
    public Logger getPluginLogger() {
        return this.getLogger();
    }

    @Override
    @Nonnull
    public String getScriptHeader() {
        return this.scriptHeader;
    }
}

