/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.platform.facet;

import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.platform.facet.Facet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import org.checkerframework.checker.nullness.qual.NonNull;

class FacetBossBarListener<V>
implements Facet.BossBar<V> {
    private final Facet.BossBar<V> facet;
    private final Supplier<Locale> locale;

    FacetBossBarListener( @NonNull Facet.BossBar<V> facet, @NonNull Supplier<Locale> locale) {
        this.facet = facet;
        this.locale = locale;
    }

    @Override
    public void bossBarInitialized(@NonNull BossBar bar) {
        this.facet.bossBarInitialized(bar);
        this.bossBarNameChanged(bar, bar.name(), bar.name());
    }

    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        this.facet.bossBarNameChanged(bar, oldName, GlobalTranslator.render((Component)newName, (Locale)this.locale.get()));
    }

    public void bossBarPercentChanged(@NonNull BossBar bar, float oldPercent, float newPercent) {
        this.facet.bossBarPercentChanged(bar, oldPercent, newPercent);
    }

    public void bossBarColorChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color oldColor, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Color newColor) {
        this.facet.bossBarColorChanged(bar, oldColor, newColor);
    }

    public void bossBarOverlayChanged(@NonNull BossBar bar, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay oldOverlay, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BossBar.Overlay newOverlay) {
        this.facet.bossBarOverlayChanged(bar, oldOverlay, newOverlay);
    }

    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsAdded, @NonNull Set<// Could not load outer class - annotation placement on inner may be incorrect
    BossBar.Flag> flagsRemoved) {
        this.facet.bossBarFlagsChanged(bar, flagsAdded, flagsRemoved);
    }

    @Override
    public void addViewer(@NonNull V viewer) {
        this.facet.addViewer(viewer);
    }

    @Override
    public void removeViewer(@NonNull V viewer) {
        this.facet.removeViewer(viewer);
    }

    @Override
    public boolean isEmpty() {
        return this.facet.isEmpty();
    }

    @Override
    public void close() {
        this.facet.close();
    }
}

