/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.monitor;

import java.util.List;
import me.legrange.services.monitor.Measurement;
import me.legrange.services.monitor.Status;

public class State {
    private final Status status;
    private final String message;
    private final long errors;
    private final long warnings;
    private final List<Measurement> data;

    public State(List<Measurement> data) {
        this(null, null, data);
    }

    public State(Status status, String message, List<Measurement> data) {
        this.data = data;
        this.errors = data.stream().filter(state -> state.getStatus() == Status.ERROR).count();
        this.warnings = data.stream().filter(state -> state.getStatus() == Status.WARNING).count();
        Status _status = Status.OK;
        if (message == null) {
            if (this.errors > 0L) {
                message = this.warnings > 0L ? String.format("%d error%s and %d warning%s", this.errors, this.errors > 1L ? "s" : "", this.warnings, this.warnings > 1L ? "s" : "") : String.format("%d error%s", this.errors, this.errors > 1L ? "s" : "");
                _status = Status.ERROR;
            } else if (this.warnings > 0L) {
                message = String.format("%d warning%s", this.warnings, this.warnings > 1L ? "s" : "");
                _status = Status.WARNING;
            } else {
                _status = Status.OK;
            }
            this.message = message == null ? "" : message;
        } else {
            this.message = message;
            _status = Status.OK;
        }
        this.status = status == null ? _status : status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public List<Measurement> getData() {
        return this.data;
    }

    public long getErrors() {
        return this.errors;
    }

    public long getWarnings() {
        return this.warnings;
    }
}

