/*
 * Decompiled with CFR 0.152.
 */
package me.legrange.services.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.legrange.log.Log;
import me.legrange.service.Component;
import me.legrange.service.ComponentException;
import me.legrange.service.Service;
import me.legrange.services.jetty.GsonJerseyProvider;
import me.legrange.services.jetty.WithJetty;
import me.legrange.services.monitor.Measurement;
import me.legrange.services.monitor.MonitorConfig;
import me.legrange.services.monitor.State;
import me.legrange.services.monitor.StateEndpoint;
import me.legrange.services.monitor.Status;

public final class MonitorComponent
extends Component<Service, MonitorConfig>
implements WithJetty {
    private final Map<String, Supplier<State>> monitors = new HashMap<String, Supplier<State>>();
    private static MonitorComponent instance;

    public MonitorComponent(Service service) {
        super(service);
    }

    public void start(MonitorConfig config) throws ComponentException {
        instance = this;
        this.jetty().addProvider(GsonJerseyProvider.class);
        this.jetty().addEndpoint(config.getPath(), StateEndpoint.class);
        Log.info((String)"Monitoring available via HTTP on %s", (Object[])new Object[]{config.getPath()});
    }

    void addMonitor(String name, Supplier<State> function) throws ComponentException {
        if (this.monitors.containsKey(name)) {
            throw new ComponentException(String.format("Duplicate monitor name '%s'", name));
        }
        this.monitors.put(name, function);
    }

    List<String> getMonitorNames() {
        return new LinkedList<String>(this.monitors.keySet());
    }

    final Object getMonitorState(String name, boolean flatten) throws ComponentException {
        Supplier<State> sup = this.monitors.get(name);
        if (sup == null) {
            throw new ComponentException(String.format("No monitor '%s' is defined", name));
        }
        try {
            if (flatten) {
                return this.flatten(sup.get());
            }
            return sup.get();
        }
        catch (Throwable ex) {
            Log.error((Throwable)ex);
            return new State(Status.ERROR, String.format("Monitoring failure: ", ex.getMessage()), Collections.EMPTY_LIST);
        }
    }

    final Object getMonitorState(String name, String variable) throws ComponentException {
        Supplier<State> sup = this.monitors.get(name);
        if (sup == null) {
            throw new ComponentException(String.format("No monitor '%s' is defined", name));
        }
        State state = sup.get();
        Optional<Measurement> any = state.getData().stream().filter(m -> m.getName().equals(variable)).findAny();
        try {
            if (any.isPresent()) {
                return sup.get();
            }
            throw new ComponentException(String.format("No variable '%s' under '%s' is defined", variable, name));
        }
        catch (Throwable ex) {
            Log.error((Throwable)ex);
            return new State(Status.ERROR, String.format("Monitoring failure: ", ex.getMessage()), Collections.EMPTY_LIST);
        }
    }

    public String getName() {
        return "monitor";
    }

    private Map<String, Long> flatten(State state) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        res.put("statusCode", Integer.valueOf(state.getStatus().getStatusCode()).longValue());
        res.put("errors", state.getErrors());
        res.put("warnings", state.getWarnings());
        for (Measurement m : state.getData()) {
            if (m.getValue() instanceof Integer) {
                res.put(m.getName(), ((Integer)m.getValue()).longValue());
            }
            if (!(m.getValue() instanceof Long)) continue;
            res.put(m.getName(), (Long)m.getValue());
        }
        return res;
    }

    static MonitorComponent getInstance() {
        return instance;
    }
}

