/*
 * Decompiled with CFR 0.152.
 */
package me.jaimegarza.syntax.plugin;

import java.io.File;
import me.jaimegarza.syntax.AnalysisException;
import me.jaimegarza.syntax.OutputException;
import me.jaimegarza.syntax.ParsingException;
import me.jaimegarza.syntax.Syntax;
import me.jaimegarza.syntax.env.Environment;
import me.jaimegarza.syntax.language.Language;
import me.jaimegarza.syntax.language.LanguageSupport;
import me.jaimegarza.syntax.util.PathUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class SyntaxMavenPluginMojo
extends AbstractMojo {
    private static final int ARGS = 10;
    private File sourceFile;
    private File outputFile;
    private File includeFile;
    private File reportFile;
    private String language;
    private String algorithm;
    private boolean externalInclude;
    private boolean verbose;
    private boolean debug;
    private boolean emitLine;
    private boolean packed;
    private String driver;
    private int numberOfFlags;
    private int numberOfFiles;

    public void execute() throws MojoExecutionException {
        try {
            this.countFlags();
            this.countFiles();
            String[] args = new String[10 + this.numberOfFlags + this.numberOfFiles];
            int i = this.setArguments(args);
            i = this.setFlags(i, args);
            this.setFiles(i, args);
            Environment environment = new Environment("Syntax", args);
            Syntax syntax = new Syntax(environment);
            try {
                syntax.executeInternal();
            }
            catch (ParsingException e) {
                throw new MojoExecutionException("the source file cannot be parsed", (Exception)((Object)e));
            }
            catch (AnalysisException e) {
                throw new MojoExecutionException("the source file cannot be analyzed", (Exception)((Object)e));
            }
            catch (OutputException e) {
                throw new MojoExecutionException("the source file cannot be written to", (Exception)((Object)e));
            }
            finally {
                environment.release();
            }
        }
        catch (MojoExecutionException e) {
            System.err.println(e.getMessage());
            throw e;
        }
    }

    private void countFlags() {
        this.numberOfFlags = 0;
        if (this.verbose) {
            ++this.numberOfFlags;
        }
        if (this.debug) {
            ++this.numberOfFlags;
        }
        if (!this.emitLine) {
            ++this.numberOfFlags;
        }
    }

    private void countFiles() throws MojoExecutionException {
        LanguageSupport ls = null;
        for (Language l : Language.values()) {
            if (!l.support().getId().equalsIgnoreCase(this.language) && !l.support().getLanguageCode().equalsIgnoreCase(this.language)) continue;
            ls = l.support();
            break;
        }
        if (ls == null) {
            throw new MojoExecutionException("language is not supported");
        }
        this.numberOfFiles = 0;
        if (this.sourceFile == null) {
            throw new MojoExecutionException("sourceFile was not provided");
        }
        ++this.numberOfFiles;
        if (this.outputFile == null) {
            throw new MojoExecutionException("outputFile was not provided");
        }
        ++this.numberOfFiles;
        if (this.includeFile == null && this.reportFile != null) {
            this.includeFile = new File(this.replaceExtension(this.outputFile.getAbsolutePath(), ls.getIncludeExtensionSuffix()));
        }
        if (this.includeFile != null) {
            ++this.numberOfFiles;
        }
        if (this.reportFile != null) {
            ++this.numberOfFiles;
        }
    }

    private int setArguments(String[] args) {
        int i = 0;
        args[i++] = "--language";
        args[i++] = this.language;
        args[i++] = "--algorithm";
        args[i++] = this.algorithm;
        args[i++] = "--packing";
        args[i++] = this.packed ? "packed" : "tabular";
        args[i++] = "--external";
        args[i++] = this.externalInclude ? "true" : "false";
        args[i++] = "--driver";
        args[i++] = this.driver;
        return i;
    }

    private int setFlags(int i, String[] args) {
        if (this.verbose) {
            args[i++] = "-v";
        }
        if (this.debug) {
            args[i++] = "-g";
        }
        if (!this.emitLine) {
            args[i++] = "-n";
        }
        return i;
    }

    private int setFiles(int i, String[] args) {
        args[i++] = this.sourceFile.getAbsolutePath();
        args[i++] = this.outputFile.getAbsolutePath();
        if (this.includeFile != null) {
            args[i++] = this.includeFile.getAbsolutePath();
        }
        if (this.reportFile != null) {
            args[i++] = this.reportFile.getAbsolutePath();
        }
        return i;
    }

    private String replaceExtension(String filename, String extension) {
        if (filename == null) {
            return null;
        }
        return PathUtils.getFilePathWithSeparator((String)filename) + PathUtils.getFileNameNoExtension((String)filename) + extension;
    }
}

