/*
 * Decompiled with CFR 0.152.
 */
package net.flashbots.provider;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import net.flashbots.common.MevShareApiException;
import net.flashbots.models.common.JsonRpc20Request;
import net.flashbots.models.common.JsonRpc20Response;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Hash;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Sign;
import org.web3j.utils.Numeric;

public class HttpProvider
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpProvider.class);
    private final OkHttpClient httpClient;
    private final EventSource.Factory eventSourceFactory;
    private final ObjectMapper objectMapper;
    private final AtomicLong nextId = new AtomicLong();

    public HttpProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.httpClient = new OkHttpClient().newBuilder().connectTimeout(Duration.ofSeconds(30L)).writeTimeout(Duration.ofSeconds(30L)).readTimeout(Duration.ofSeconds(30L)).build();
        this.eventSourceFactory = EventSources.createFactory((OkHttpClient)this.httpClient);
    }

    public <T> CompletableFuture<T> send(Request request, final JavaType respType) {
        LOGGER.trace("Sending request: {}", (Object)request);
        final CompletableFuture completableFuture = new CompletableFuture();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                LOGGER.error("JsonRpcError sending request", (Throwable)e);
                completableFuture.completeExceptionally(e);
            }

            public void onResponse(Call call, Response response) {
                try {
                    if (response.body() != null) {
                        String respBody = response.body().string();
                        LOGGER.trace("Received response: {}", (Object)respBody);
                        Object res = HttpProvider.this.objectMapper.readValue(respBody, respType);
                        completableFuture.complete(res);
                    }
                }
                catch (IOException | IllegalStateException e) {
                    LOGGER.error("JsonRpcError parsing response", (Throwable)e);
                    completableFuture.completeExceptionally(e);
                }
            }
        });
        return completableFuture;
    }

    public <T> CompletableFuture<T> send(String url, JsonRpc20Request request, Credentials authSigner, JavaType respType) {
        String requestBodyJson;
        CompletableFuture future = new CompletableFuture();
        try {
            requestBodyJson = this.objectMapper.writeValueAsString((Object)request);
            LOGGER.trace("request body: {}", (Object)requestBodyJson);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("JsonRpcError serializing request", (Throwable)e);
            future.completeExceptionally(e);
            return future;
        }
        Sign.SignatureData signatureData = Sign.signPrefixedMessage((byte[])Hash.sha3String((String)requestBodyJson).getBytes(StandardCharsets.UTF_8), (ECKeyPair)authSigner.getEcKeyPair());
        byte[] signatureBytes = new byte[65];
        System.arraycopy(signatureData.getR(), 0, signatureBytes, 0, 32);
        System.arraycopy(signatureData.getS(), 0, signatureBytes, 32, 32);
        signatureBytes[64] = signatureData.getV()[0];
        String signature = String.format("%s:%s", Numeric.prependHexPrefix((String)Keys.getAddress((BigInteger)authSigner.getEcKeyPair().getPublicKey())), Numeric.toHexString((byte[])signatureBytes));
        LOGGER.trace("signature: {}", (Object)signature);
        RequestBody requestBody = RequestBody.create((String)requestBodyJson, (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request okhttpRequest = new Request.Builder().url(url).post(requestBody).addHeader("X-Flashbots-Signature", signature).addHeader("Content-Type", "application/json; charset=utf-8").build();
        return ((CompletableFuture)this.send(okhttpRequest, this.objectMapper.getTypeFactory().constructParametricType(JsonRpc20Response.class, new JavaType[]{respType})).thenCompose(jsonRpc20Response -> {
            JsonRpc20Response resp = (JsonRpc20Response)jsonRpc20Response;
            if (resp.getError() != null) {
                MevShareApiException e;
                if (resp.getThrowable() != null) {
                    e = new MevShareApiException(resp.getThrowable());
                    e.setError(resp.getError());
                } else {
                    e = new MevShareApiException(resp.getError());
                }
                future.completeExceptionally(e);
            } else {
                future.complete(resp.getResult());
            }
            return future;
        })).exceptionallyCompose(throwable -> {
            if (throwable instanceof MevShareApiException) {
                future.completeExceptionally((Throwable)throwable);
                return future;
            }
            MevShareApiException e = new MevShareApiException((Throwable)throwable);
            future.completeExceptionally(e);
            return future;
        });
    }

    public EventSource.Factory eventSourceFactory() {
        return this.eventSourceFactory;
    }

    public JsonRpc20Request createJsonRpc20Request(String method, List<?> params) {
        JsonRpc20Request request = new JsonRpc20Request();
        request.setId(this.nextId());
        request.setMethod(method);
        request.setParams(params);
        return request;
    }

    private long nextId() {
        return this.nextId.incrementAndGet();
    }

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }
}

