/*
 * Decompiled with CFR 0.152.
 */
package net.flashbots.models.event;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import net.flashbots.models.event.Transaction;
import net.flashbots.provider.json.HexStringToBigIntDeserializer;
import org.web3j.protocol.core.methods.response.EthLog;

public class MevShareEvent {
    private List<Transaction> txs;
    private String hash;
    @JsonDeserialize(using=EthLog.LogResultDeserialiser.class)
    private List<EthLog.LogResult<?>> logs;
    @JsonDeserialize(using=HexStringToBigIntDeserializer.class)
    private BigInteger gasUsed;
    @JsonDeserialize(using=HexStringToBigIntDeserializer.class)
    private BigInteger mevGasPrice;

    public List<Transaction> getTxs() {
        return this.txs;
    }

    public MevShareEvent setTxs(List<Transaction> txs) {
        this.txs = txs;
        return this;
    }

    public String getHash() {
        return this.hash;
    }

    public MevShareEvent setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public List<EthLog.LogResult<?>> getLogs() {
        return this.logs;
    }

    public MevShareEvent setLogs(List<EthLog.LogResult<?>> logs) {
        this.logs = logs;
        return this;
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public MevShareEvent setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
        return this;
    }

    public BigInteger getMevGasPrice() {
        return this.mevGasPrice;
    }

    public MevShareEvent setMevGasPrice(BigInteger mevGasPrice) {
        this.mevGasPrice = mevGasPrice;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MevShareEvent)) {
            return false;
        }
        MevShareEvent mevShareEvent = (MevShareEvent)o;
        return Objects.equals(this.gasUsed, mevShareEvent.gasUsed) && Objects.equals(this.mevGasPrice, mevShareEvent.mevGasPrice) && Objects.equals(this.txs, mevShareEvent.txs) && Objects.equals(this.hash, mevShareEvent.hash) && Objects.equals(this.logs, mevShareEvent.logs);
    }

    public int hashCode() {
        return Objects.hash(this.txs, this.hash, this.logs, this.gasUsed, this.mevGasPrice);
    }

    public String toString() {
        return "MevShareEvent{txs=" + this.txs + ", hash='" + this.hash + "', logs=" + this.logs + ", gasUsed=" + this.gasUsed + ", mevGasPrice=" + this.mevGasPrice + "}";
    }
}

