/*
 * Decompiled with CFR 0.152.
 */
package net.flashbots.models.bundle;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import net.flashbots.models.bundle.BundlePrivacy;
import net.flashbots.models.bundle.PrivateTxOptions;
import net.flashbots.provider.json.BigIntToHexStringSerializer;

public class PrivateTxParams {
    private String tx;
    @JsonSerialize(using=BigIntToHexStringSerializer.class)
    private BigInteger maxBlockNumber;
    private Preferences preferences;

    public String getTx() {
        return this.tx;
    }

    public PrivateTxParams setTx(String tx) {
        this.tx = tx;
        return this;
    }

    public BigInteger getMaxBlockNumber() {
        return this.maxBlockNumber;
    }

    public PrivateTxParams setMaxBlockNumber(BigInteger maxBlockNumber) {
        this.maxBlockNumber = maxBlockNumber;
        return this;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public PrivateTxParams setPreferences(Preferences preferences) {
        this.preferences = preferences;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrivateTxParams)) {
            return false;
        }
        PrivateTxParams that = (PrivateTxParams)o;
        return Objects.equals(this.tx, that.tx) && Objects.equals(this.maxBlockNumber, that.maxBlockNumber) && Objects.equals(this.preferences, that.preferences);
    }

    public int hashCode() {
        return Objects.hash(this.tx, this.maxBlockNumber, this.preferences);
    }

    public String toString() {
        return "PrivateTxParams{tx='" + this.tx + "', maxBlockNumber=" + this.maxBlockNumber + ", preferences=" + this.preferences + "}";
    }

    public static PrivateTxParams from(String tx, PrivateTxOptions options) {
        PrivateTxParams params = new PrivateTxParams();
        params.setTx(tx);
        Preferences preferences = new Preferences();
        preferences.setFast(true);
        if (options != null) {
            params.setMaxBlockNumber(options.getMaxBlockNumber());
            preferences.setBuilders(options.getBuilders());
            preferences.setPrivacy(new BundlePrivacy().setHints(options.getHints()));
        }
        params.setPreferences(preferences);
        return params;
    }

    public static class Preferences {
        private boolean fast;
        private BundlePrivacy privacy;
        private List<String> builders;

        public boolean getFast() {
            return this.fast;
        }

        public Preferences setFast(boolean fast) {
            this.fast = fast;
            return this;
        }

        public BundlePrivacy getPrivacy() {
            return this.privacy;
        }

        public Preferences setPrivacy(BundlePrivacy privacy) {
            this.privacy = privacy;
            return this;
        }

        public List<String> getBuilders() {
            return this.builders;
        }

        public Preferences setBuilders(List<String> builders) {
            this.builders = builders;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Preferences)) {
                return false;
            }
            Preferences that = (Preferences)o;
            return this.fast == that.fast && Objects.equals(this.privacy, that.privacy) && Objects.equals(this.builders, that.builders);
        }

        public int hashCode() {
            return Objects.hash(this.fast, this.privacy, this.builders);
        }

        public String toString() {
            return "Preferences{fast=" + this.fast + ", privacy=" + this.privacy + ", builders=" + this.builders + "}";
        }
    }
}

