/*
 * Decompiled with CFR 0.152.
 */
package net.flashbots.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.FlowableEmitter;
import net.flashbots.common.MevShareApiException;
import net.flashbots.models.event.MevShareEvent;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MevShareEventListener
extends EventSourceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MevShareEventListener.class);
    private final FlowableEmitter<MevShareEvent> emitter;
    private final ObjectMapper objectMapper;

    public MevShareEventListener(FlowableEmitter<MevShareEvent> emitter, ObjectMapper objectMapper) {
        this.emitter = emitter;
        this.objectMapper = objectMapper;
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        LOGGER.trace("EventSource received event: id={}, type={}, data={}", new Object[]{id, type, data});
        if (StringUtils.isEmpty((CharSequence)data) || ":ping".equals(data)) {
            return;
        }
        try {
            MevShareEvent mevShareEvent = (MevShareEvent)this.objectMapper.readValue(data, MevShareEvent.class);
            if (!this.emitter.isCancelled()) {
                this.emitter.onNext((Object)mevShareEvent);
            }
        }
        catch (JsonProcessingException e) {
            LOGGER.error("JsonRpcError parsing response", (Throwable)e);
            MevShareApiException mse = new MevShareApiException(e);
            if (this.emitter != null && !this.emitter.isCancelled()) {
                this.emitter.onError((Throwable)mse);
            }
            throw mse;
        }
    }

    public void onClosed(EventSource eventSource) {
        LOGGER.trace("EventSource closed");
        this.emitter.onComplete();
    }

    public void onFailure(EventSource eventSource, Throwable t, Response response) {
        LOGGER.error("EventSource failed", t);
        this.emitter.onComplete();
    }

    public void onOpen(EventSource eventSource, Response response) {
        LOGGER.trace("EventSource opened");
    }
}

