/*
 * Decompiled with CFR 0.152.
 */
package net.flashbots;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.disposables.Disposable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.flashbots.MevShareApi;
import net.flashbots.common.MevShareApiException;
import net.flashbots.common.MevShareEventListener;
import net.flashbots.models.bundle.BundleItemType;
import net.flashbots.models.bundle.BundleParams;
import net.flashbots.models.bundle.PrivateTxOptions;
import net.flashbots.models.bundle.PrivateTxParams;
import net.flashbots.models.bundle.SendBundleResponse;
import net.flashbots.models.bundle.SimBundleOptions;
import net.flashbots.models.bundle.SimBundleResponse;
import net.flashbots.models.common.JsonRpc20Request;
import net.flashbots.models.common.Network;
import net.flashbots.models.event.EventHistoryEntry;
import net.flashbots.models.event.EventHistoryInfo;
import net.flashbots.models.event.EventHistoryParams;
import net.flashbots.models.event.MevShareEvent;
import net.flashbots.provider.HttpProvider;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.Credentials;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.TransactionEncoder;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.EthTransaction;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.utils.Numeric;

public class MevShareClient
implements MevShareApi,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MevShareClient.class);
    private static final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Credentials authSigner;
    private final HttpProvider provider;
    private final Network network;
    private final Web3j web3j;

    public MevShareClient(Network network, Credentials authSigner, Web3j web3j) {
        this.network = network;
        this.provider = new HttpProvider(objectMapper);
        this.authSigner = authSigner;
        this.web3j = web3j;
    }

    @Override
    public CompletableFuture<EventHistoryInfo> getEventHistoryInfo() {
        Request request = new Request.Builder().url(this.network.streamUrl() + "/api/v1/history/info").get().build();
        return this.provider.send(request, objectMapper.constructType(EventHistoryInfo.class));
    }

    @Override
    public CompletableFuture<List<EventHistoryEntry>> getEventHistory(EventHistoryParams params) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)(this.network.streamUrl() + "/api/v1/history"))).newBuilder();
        if (params != null) {
            if (params.getBlockStart() != null) {
                urlBuilder.addQueryParameter("blockStart", params.getBlockStart().toString());
            }
            if (params.getBlockEnd() != null) {
                urlBuilder.addQueryParameter("blockEnd", params.getBlockEnd().toString());
            }
            if (params.getTimestampStart() != null) {
                urlBuilder.addQueryParameter("timestampStart", params.getTimestampStart().toString());
            }
            if (params.getTimestampEnd() != null) {
                urlBuilder.addQueryParameter("timestampEnd", params.getTimestampEnd().toString());
            }
            if (params.getLimit() != null) {
                urlBuilder.addQueryParameter("limit", params.getLimit().toString());
            }
            if (params.getOffset() != null) {
                urlBuilder.addQueryParameter("offset", params.getOffset().toString());
            }
        }
        Request request = new Request.Builder().url(urlBuilder.build().url()).get().build();
        return this.provider.send(request, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, EventHistoryEntry.class));
    }

    @Override
    public Disposable subscribe(Consumer<MevShareEvent> consumer) {
        return Flowable.create(subscriber -> {
            Request request = new Request.Builder().url(this.network.streamUrl()).get().build();
            MevShareEventListener eventListener = new MevShareEventListener((FlowableEmitter<MevShareEvent>)subscriber, objectMapper);
            EventSource eventSource = this.provider.eventSourceFactory().newEventSource(request, (EventSourceListener)eventListener);
            subscriber.setCancellable(() -> ((EventSource)eventSource).cancel());
        }, (BackpressureStrategy)BackpressureStrategy.MISSING).subscribe(consumer::accept);
    }

    @Override
    public Disposable subscribeTx(Consumer<MevShareEvent> consumer) {
        return this.subscribe(mevShareEvent -> {
            if (mevShareEvent.getTxs() == null || mevShareEvent.getTxs().size() == 1) {
                consumer.accept((MevShareEvent)mevShareEvent);
            }
        });
    }

    @Override
    public Disposable subscribeBundle(Consumer<MevShareEvent> consumer) {
        return this.subscribe(mevShareEvent -> {
            if (mevShareEvent.getTxs() != null && mevShareEvent.getTxs().size() > 1) {
                consumer.accept((MevShareEvent)mevShareEvent);
            }
        });
    }

    @Override
    public CompletableFuture<SendBundleResponse> sendBundle(BundleParams params) {
        JsonRpc20Request request = this.provider.createJsonRpc20Request("mev_sendBundle", List.of(params));
        return this.provider.send(this.network.rpcUrl(), request, this.authSigner, objectMapper.constructType(SendBundleResponse.class));
    }

    @Override
    public CompletableFuture<SimBundleResponse> simBundle(BundleParams params, SimBundleOptions options) {
        SimBundleOptions realOptions = options == null ? new SimBundleOptions() : options;
        JsonRpc20Request request = this.provider.createJsonRpc20Request("mev_simBundle", List.of(params, realOptions));
        return this.provider.send(this.network.rpcUrl(), request, this.authSigner, objectMapper.constructType(SimBundleResponse.class));
    }

    @Override
    public CompletableFuture<SimBundleResponse> simulateBundle(BundleParams params, SimBundleOptions options) {
        BundleItemType bundleItemType = params.getBody().get(0);
        if (!(bundleItemType instanceof BundleItemType.HashItem)) {
            return this.simBundle(params, options);
        }
        BundleItemType.HashItem firstTx = (BundleItemType.HashItem)bundleItemType;
        return this.createSimulateBundle(firstTx, params, options);
    }

    @Override
    public CompletableFuture<String> sendPrivateTransaction(String signedRawTx, PrivateTxOptions options) {
        PrivateTxParams tx = PrivateTxParams.from(signedRawTx, options);
        JsonRpc20Request request = this.provider.createJsonRpc20Request("eth_sendPrivateTransaction", List.of(tx));
        return this.provider.send(this.network.rpcUrl(), request, this.authSigner, objectMapper.constructType(String.class));
    }

    private CompletableFuture<SimBundleResponse> createSimulateBundle(BundleItemType.HashItem firstTx, BundleParams params, SimBundleOptions options) {
        return this.getTransaction(firstTx.getHash()).thenCompose(tx -> {
            if (tx.getTransaction().isEmpty()) {
                return CompletableFuture.failedFuture(new MevShareApiException("Target transaction did not appear on chain"));
            }
            BigInteger simBlock = options != null && options.getParentBlock() != null ? options.getParentBlock() : ((Transaction)tx.getTransaction().get()).getBlockNumber().subtract(BigInteger.ONE);
            Transaction transaction = (Transaction)tx.getTransaction().get();
            LOGGER.debug("Transaction {}", (Object)transaction);
            RawTransaction rawTransaction = "0x2".equalsIgnoreCase(transaction.getType()) ? RawTransaction.createTransaction((long)transaction.getChainId(), (BigInteger)transaction.getNonce(), (BigInteger)transaction.getGas(), (String)transaction.getTo(), (BigInteger)transaction.getValue(), (String)transaction.getInput(), (BigInteger)transaction.getMaxPriorityFeePerGas(), (BigInteger)transaction.getMaxFeePerGas()) : ("0x1".equalsIgnoreCase(transaction.getType()) ? RawTransaction.createTransaction((long)transaction.getChainId(), (BigInteger)transaction.getNonce(), (BigInteger)transaction.getGasPrice(), (BigInteger)transaction.getGas(), (String)transaction.getTo(), (BigInteger)transaction.getValue(), (String)transaction.getInput(), transaction.getAccessList().stream().map(accessListObject -> {
                AccessListObject accessListObjectRaw = new AccessListObject();
                accessListObjectRaw.setAddress(accessListObject.getAddress());
                accessListObjectRaw.setStorageKeys(accessListObject.getStorageKeys());
                return accessListObjectRaw;
            }).collect(Collectors.toList())) : RawTransaction.createTransaction((BigInteger)transaction.getNonce(), (BigInteger)transaction.getGasPrice(), (BigInteger)transaction.getGas(), (String)transaction.getTo(), (BigInteger)transaction.getValue(), (String)transaction.getInput()));
            Sign.SignatureData signatureData = new Sign.SignatureData(Sign.getVFromRecId((int)((int)transaction.getV())), Numeric.hexStringToByteArray((String)transaction.getR()), Numeric.hexStringToByteArray((String)transaction.getS()));
            ArrayList<BundleItemType> body = new ArrayList<BundleItemType>(params.getBody());
            body.set(0, new BundleItemType.TxItem().setTx(Numeric.toHexString((byte[])TransactionEncoder.encode((RawTransaction)rawTransaction, (Sign.SignatureData)signatureData))).setCanRevert(false));
            BundleParams paramsWithSignedTx = params.clone().setBody(body);
            SimBundleOptions newOptions = options == null ? new SimBundleOptions() : options.clone();
            newOptions.setParentBlock(simBlock);
            return this.simBundle(paramsWithSignedTx, newOptions);
        });
    }

    private CompletableFuture<EthTransaction> getTransaction(String hash) {
        return this.web3j.ethGetTransactionByHash(hash).sendAsync().thenCompose(res -> {
            if (res.getTransaction().isEmpty()) {
                CountDownLatch latch = new CountDownLatch(1);
                CompletableFuture txFuture = new CompletableFuture();
                Disposable disposable = null;
                try {
                    disposable = this.web3j.blockFlowable(false).subscribe(block -> {
                        EthTransaction hashTx = (EthTransaction)this.web3j.ethGetTransactionByHash(hash).send();
                        if (hashTx.getTransaction().isPresent()) {
                            txFuture.complete(hashTx);
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await(5L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Interrupted while waiting for transaction by hash", (Throwable)e);
                        if (!disposable.isDisposed()) {
                            disposable.dispose();
                        }
                        Thread.currentThread().interrupt();
                        CompletableFuture completableFuture = CompletableFuture.failedFuture(new MevShareApiException("Interrupted while waiting for transaction by hash", e));
                        if (disposable != null && !disposable.isDisposed()) {
                            disposable.dispose();
                        }
                        return completableFuture;
                    }
                    if (!disposable.isDisposed()) {
                        disposable.dispose();
                    }
                    if (!txFuture.isDone()) {
                        CompletableFuture completableFuture = CompletableFuture.failedFuture(new MevShareApiException("Failed to get transaction by hash after 5 minutes"));
                        return completableFuture;
                    }
                }
                finally {
                    if (disposable != null && !disposable.isDisposed()) {
                        disposable.dispose();
                    }
                }
                return txFuture;
            }
            return CompletableFuture.completedFuture(res);
        });
    }

    @Override
    public void close() {
        this.web3j.shutdown();
        this.provider.close();
    }
}

