/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.examples;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import me.grapebaba.hyperledger.fabric.ErrorResolver;
import me.grapebaba.hyperledger.fabric.Fabric;
import me.grapebaba.hyperledger.fabric.Hyperledger;
import me.grapebaba.hyperledger.fabric.models.Block;
import me.grapebaba.hyperledger.fabric.models.BlockchainInfo;
import me.grapebaba.hyperledger.fabric.models.ChaincodeID;
import me.grapebaba.hyperledger.fabric.models.ChaincodeInput;
import me.grapebaba.hyperledger.fabric.models.ChaincodeOpPayload;
import me.grapebaba.hyperledger.fabric.models.ChaincodeOpResult;
import me.grapebaba.hyperledger.fabric.models.ChaincodeSpec;
import me.grapebaba.hyperledger.fabric.models.Error;
import me.grapebaba.hyperledger.fabric.models.OK;
import me.grapebaba.hyperledger.fabric.models.OK1;
import me.grapebaba.hyperledger.fabric.models.PeerEndpoint;
import me.grapebaba.hyperledger.fabric.models.PeersMessage;
import me.grapebaba.hyperledger.fabric.models.Secret;
import me.grapebaba.hyperledger.fabric.models.Transaction;
import okhttp3.Interceptor;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class FabricExample {
    private static final HttpLoggingInterceptor HTTP_LOGGING_INTERCEPTOR = new HttpLoggingInterceptor();
    private static final Fabric FABRIC;
    private static final Logger LOG;

    public static void main(String[] args) throws Exception {
        FABRIC.chaincode(ChaincodeOpPayload.builder().jsonrpc("2.0").id(1L).method("deploy").params(ChaincodeSpec.builder().chaincodeID(ChaincodeID.builder().name("mycc").build()).ctorMsg(ChaincodeInput.builder().function("init").args(Arrays.asList("a", "100", "b", "200")).build()).secureContext("jim").type(ChaincodeSpec.Type.GOLANG).build()).build()).subscribe((Action1)new Action1<ChaincodeOpResult>(){

            public void call(ChaincodeOpResult chaincodeOpResult) {
                System.out.printf("Deploy chaincode result:%s\n", chaincodeOpResult);
            }
        });
        FABRIC.chaincode(ChaincodeOpPayload.builder().jsonrpc("2.0").id(1L).method("invoke").params(ChaincodeSpec.builder().chaincodeID(ChaincodeID.builder().name("mycc").build()).ctorMsg(ChaincodeInput.builder().function("invoke").args(Arrays.asList("a", "b", "10")).build()).secureContext("jim").type(ChaincodeSpec.Type.GOLANG).build()).build()).flatMap((Func1)new Func1<ChaincodeOpResult, Observable<Transaction>>(){

            public Observable<Transaction> call(ChaincodeOpResult chaincodeOpResult) {
                System.out.printf("Invoke chaincode result:%s\n", chaincodeOpResult);
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return FABRIC.getTransaction(chaincodeOpResult.getResult().getMessage());
            }
        }).subscribe((Action1)new Action1<Transaction>(){

            public void call(Transaction transaction) {
                System.out.printf("Get transaction:%s\n", transaction);
            }
        });
        FABRIC.chaincode(ChaincodeOpPayload.builder().jsonrpc("2.0").id(1L).method("query").params(ChaincodeSpec.builder().chaincodeID(ChaincodeID.builder().name("mycc").build()).ctorMsg(ChaincodeInput.builder().function("query").args(Collections.singletonList("b")).build()).secureContext("jim").type(ChaincodeSpec.Type.GOLANG).build()).build()).subscribe((Action1)new Action1<ChaincodeOpResult>(){

            public void call(ChaincodeOpResult chaincodeOpResult) {
                System.out.printf("Query chaincode result:%s\n", chaincodeOpResult);
            }
        });
        FABRIC.chaincode(ChaincodeOpPayload.builder().jsonrpc("2.0").id(1L).method("query").params(ChaincodeSpec.builder().chaincodeID(ChaincodeID.builder().name("mycc").build()).ctorMsg(ChaincodeInput.builder().function("query").args(Collections.singletonList("c")).build()).secureContext("jim").type(ChaincodeSpec.Type.GOLANG).build()).build()).subscribe((Action1)new Action1<ChaincodeOpResult>(){

            public void call(ChaincodeOpResult chaincodeOpResult) {
                System.out.printf("Query chaincode result:%s\n", chaincodeOpResult);
            }
        });
        FABRIC.getBlockchain().subscribe((Action1)new Action1<BlockchainInfo>(){

            public void call(BlockchainInfo blockchainInfo) {
                System.out.printf("Get blockchain info:%s\n", blockchainInfo);
            }
        });
        FABRIC.getBlock(0).subscribe((Action1)new Action1<Block>(){

            public void call(Block block) {
                System.out.printf("Get Block info:%s\n", block);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                Error error = (Error)ErrorResolver.resolve((Throwable)throwable, Error.class);
                System.out.printf("Error message:%s\n", error.getError());
            }
        });
        FABRIC.getBlock(1).subscribe((Action1)new Action1<Block>(){

            public void call(Block block) {
                System.out.printf("Get Block info:%s\n", block);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                Error error = (Error)ErrorResolver.resolve((Throwable)throwable, Error.class);
                System.out.printf("Error message:%s\n", error.getError());
            }
        });
        FABRIC.getNetworkPeers().subscribe((Action1)new Action1<PeersMessage>(){

            public void call(PeersMessage peersMessage) {
                for (PeerEndpoint peerEndpoint : peersMessage.getPeers()) {
                    System.out.printf("Peer message:%s\n", peerEndpoint);
                }
            }
        });
        FABRIC.deleteRegistrar("lukas").subscribe((Action1)new Action1<OK>(){

            public void call(OK ok) {
                System.out.printf("Delete registrar ok message:%s\n", ok);
            }
        });
        FABRIC.createRegistrar(Secret.builder().enrollId("lukas").enrollSecret("NPKYL39uKbkj1").build()).subscribe((Action1)new Action1<OK>(){

            public void call(OK ok) {
                System.out.printf("Create registrar ok message:%s\n", ok);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                Error error = (Error)ErrorResolver.resolve((Throwable)throwable, Error.class);
                System.out.printf("Error message:%s\n", error);
            }
        });
        FABRIC.createRegistrar(Secret.builder().enrollId("jim").enrollSecret("6avZQLwcUe9b").build()).subscribe((Action1)new Action1<OK>(){

            public void call(OK ok) {
                System.out.printf("Create registrar ok message:%s\n", ok);
            }
        }, (Action1)new Action1<Throwable>(){

            public void call(Throwable throwable) {
                Error error = (Error)ErrorResolver.resolve((Throwable)throwable, Error.class);
                System.out.printf("Error message:%s\n", error);
            }
        });
        FABRIC.getRegistrar("jim").subscribe((Action1)new Action1<OK>(){

            public void call(OK ok) {
                System.out.printf("Get registrar ok message:%s\n", ok);
            }
        });
        FABRIC.getRegistrarECERT("jim").subscribe((Action1)new Action1<OK>(){

            public void call(OK ok) {
                System.out.printf("Get registrar ecert ok message:%s\n", ok);
            }
        });
        FABRIC.getRegistrarTCERT("jim").subscribe((Action1)new Action1<OK1>(){

            public void call(OK1 ok) {
                for (String okString : ok.getOk()) {
                    System.out.printf("Get registrar tcert ok message:%s\n", okString);
                }
            }
        });
    }

    static {
        HTTP_LOGGING_INTERCEPTOR.setLevel(HttpLoggingInterceptor.Level.BODY);
        FABRIC = Hyperledger.fabric((String)"http://localhost:3000/", (Interceptor[])new Interceptor[]{HTTP_LOGGING_INTERCEPTOR});
        LOG = LoggerFactory.getLogger(FabricExample.class);
    }
}

