/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionResult {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionResult.class);
    private String uuid;
    private String result;
    private int errorCode;
    private String error;

    TransactionResult(String uuid, String result, int errorCode, String error) {
        this.uuid = uuid;
        this.result = result;
        this.errorCode = errorCode;
        this.error = error;
    }

    public static TransactionResultBuilder builder() {
        return new TransactionResultBuilder();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getResult() {
        return this.result;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getError() {
        return this.error;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public void setError(String error) {
        this.error = error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionResult that = (TransactionResult)o;
        return this.errorCode == that.errorCode && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.result, that.result) && Objects.equals(this.error, that.error);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.result, this.errorCode, this.error);
    }

    public String toString() {
        return "TransactionResult(uuid=" + this.getUuid() + ", result=" + this.getResult() + ", errorCode=" + this.getErrorCode() + ", error=" + this.getError() + ")";
    }

    public static class TransactionResultBuilder {
        private String uuid;
        private String result;
        private int errorCode;
        private String error;

        TransactionResultBuilder() {
        }

        public TransactionResultBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public TransactionResultBuilder result(String result) {
            this.result = result;
            return this;
        }

        public TransactionResultBuilder errorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public TransactionResultBuilder error(String error) {
            this.error = error;
            return this;
        }

        public TransactionResult build() {
            return new TransactionResult(this.uuid, this.result, this.errorCode, this.error);
        }

        public String toString() {
            return "TransactionResult.TransactionResultBuilder(uuid=" + this.uuid + ", result=" + this.result + ", errorCode=" + this.errorCode + ", error=" + this.error + ")";
        }
    }
}

