/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.ConfidentialityLevel;
import me.grapebaba.hyperledger.fabric.models.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final Logger LOG = LoggerFactory.getLogger(Transaction.class);
    private Type type;
    private String chaincodeID;
    private String payload;
    private String metadata;
    private String uuid;
    private Timestamp timestamp;
    private ConfidentialityLevel confidentialityLevel;
    private String nonce;
    private String confidentialityProtocolVersion;
    private String toValidators;
    private String cert;
    private String signature;

    Transaction(Type type, String chaincodeID, String payload, String metadata, String uuid, Timestamp timestamp, ConfidentialityLevel confidentialityLevel, String nonce, String confidentialityProtocolVersion, String toValidators, String cert, String signature) {
        this.type = type;
        this.chaincodeID = chaincodeID;
        this.payload = payload;
        this.metadata = metadata;
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.confidentialityLevel = confidentialityLevel;
        this.nonce = nonce;
        this.confidentialityProtocolVersion = confidentialityProtocolVersion;
        this.toValidators = toValidators;
        this.cert = cert;
        this.signature = signature;
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public Type getType() {
        return this.type;
    }

    public String getChaincodeID() {
        return this.chaincodeID;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public ConfidentialityLevel getConfidentialityLevel() {
        return this.confidentialityLevel;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getConfidentialityProtocolVersion() {
        return this.confidentialityProtocolVersion;
    }

    public String getToValidators() {
        return this.toValidators;
    }

    public String getCert() {
        return this.cert;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setChaincodeID(String chaincodeID) {
        this.chaincodeID = chaincodeID;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setConfidentialityLevel(ConfidentialityLevel confidentialityLevel) {
        this.confidentialityLevel = confidentialityLevel;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setConfidentialityProtocolVersion(String confidentialityProtocolVersion) {
        this.confidentialityProtocolVersion = confidentialityProtocolVersion;
    }

    public void setToValidators(String toValidators) {
        this.toValidators = toValidators;
    }

    public void setCert(String cert) {
        this.cert = cert;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.type == that.type && Objects.equals(this.chaincodeID, that.chaincodeID) && Objects.equals(this.payload, that.payload) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.timestamp, that.timestamp) && this.confidentialityLevel == that.confidentialityLevel && Objects.equals(this.nonce, that.nonce) && Objects.equals(this.confidentialityProtocolVersion, that.confidentialityProtocolVersion) && Objects.equals(this.toValidators, that.toValidators) && Objects.equals(this.cert, that.cert) && Objects.equals(this.signature, that.signature);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.chaincodeID, this.payload, this.metadata, this.uuid, this.timestamp, this.confidentialityLevel, this.nonce, this.confidentialityProtocolVersion, this.toValidators, this.cert, this.signature});
    }

    public String toString() {
        return "Transaction(type=" + (Object)((Object)this.getType()) + ", chaincodeID=" + this.getChaincodeID() + ", payload=" + this.getPayload() + ", metadata=" + this.getMetadata() + ", uuid=" + this.getUuid() + ", timestamp=" + this.getTimestamp() + ", confidentialityLevel=" + (Object)((Object)this.getConfidentialityLevel()) + ", nonce=" + this.getNonce() + ", confidentialityProtocolVersion=" + this.getConfidentialityProtocolVersion() + ", toValidators=" + this.getToValidators() + ", cert=" + this.getCert() + ", signature=" + this.getSignature() + ")";
    }

    public static class TransactionBuilder {
        private Type type;
        private String chaincodeID;
        private String payload;
        private String metadata;
        private String uuid;
        private Timestamp timestamp;
        private ConfidentialityLevel confidentialityLevel;
        private String nonce;
        private String confidentialityProtocolVersion;
        private String toValidators;
        private String cert;
        private String signature;

        TransactionBuilder() {
        }

        public TransactionBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public TransactionBuilder chaincodeID(String chaincodeID) {
            this.chaincodeID = chaincodeID;
            return this;
        }

        public TransactionBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public TransactionBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public TransactionBuilder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public TransactionBuilder timestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public TransactionBuilder confidentialityLevel(ConfidentialityLevel confidentialityLevel) {
            this.confidentialityLevel = confidentialityLevel;
            return this;
        }

        public TransactionBuilder nonce(String nonce) {
            this.nonce = nonce;
            return this;
        }

        public TransactionBuilder confidentialityProtocolVersion(String confidentialityProtocolVersion) {
            this.confidentialityProtocolVersion = confidentialityProtocolVersion;
            return this;
        }

        public TransactionBuilder toValidators(String toValidators) {
            this.toValidators = toValidators;
            return this;
        }

        public TransactionBuilder cert(String cert) {
            this.cert = cert;
            return this;
        }

        public TransactionBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public Transaction build() {
            return new Transaction(this.type, this.chaincodeID, this.payload, this.metadata, this.uuid, this.timestamp, this.confidentialityLevel, this.nonce, this.confidentialityProtocolVersion, this.toValidators, this.cert, this.signature);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(type=" + (Object)((Object)this.type) + ", chaincodeID=" + this.chaincodeID + ", payload=" + this.payload + ", metadata=" + this.metadata + ", uuid=" + this.uuid + ", timestamp=" + this.timestamp + ", confidentialityLevel=" + (Object)((Object)this.confidentialityLevel) + ", nonce=" + this.nonce + ", confidentialityProtocolVersion=" + this.confidentialityProtocolVersion + ", toValidators=" + this.toValidators + ", cert=" + this.cert + ", signature=" + this.signature + ")";
        }
    }

    public static enum Type {
        UNDEFINED,
        CHAINCODE_DEPLOY,
        CHAINCODE_INVOKE,
        CHAINCODE_QUERY,
        CHAINCODE_TERMINATE;

    }
}

