/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcError {
    private static final Logger LOG = LoggerFactory.getLogger(RpcError.class);
    private long code;
    private String message;
    private String data;

    RpcError(long code, String message, String data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static RpcErrorBuilder builder() {
        return new RpcErrorBuilder();
    }

    public long getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }

    public void setCode(long code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcError rpcError = (RpcError)o;
        return this.code == rpcError.code && Objects.equals(this.message, rpcError.message) && Objects.equals(this.data, rpcError.data);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.data);
    }

    public String toString() {
        return "RpcError(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ")";
    }

    public static class RpcErrorBuilder {
        private long code;
        private String message;
        private String data;

        RpcErrorBuilder() {
        }

        public RpcErrorBuilder code(long code) {
            this.code = code;
            return this;
        }

        public RpcErrorBuilder message(String message) {
            this.message = message;
            return this;
        }

        public RpcErrorBuilder data(String data) {
            this.data = data;
            return this;
        }

        public RpcError build() {
            return new RpcError(this.code, this.message, this.data);
        }

        public String toString() {
            return "RpcError.RpcErrorBuilder(code=" + this.code + ", message=" + this.message + ", data=" + this.data + ")";
        }
    }
}

