/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.RpcError;
import me.grapebaba.hyperledger.fabric.models.RpcResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaincodeOpResult {
    private static final Logger LOG = LoggerFactory.getLogger(ChaincodeOpResult.class);
    private String jsonrpc;
    private long id;
    private RpcError error;
    private RpcResponse result;

    ChaincodeOpResult(String jsonrpc, long id, RpcError error, RpcResponse result) {
        this.jsonrpc = jsonrpc;
        this.id = id;
        this.error = error;
        this.result = result;
    }

    public static ChaincodeOpResultBuilder builder() {
        return new ChaincodeOpResultBuilder();
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public long getId() {
        return this.id;
    }

    public RpcError getError() {
        return this.error;
    }

    public RpcResponse getResult() {
        return this.result;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setError(RpcError error) {
        this.error = error;
    }

    public void setResult(RpcResponse result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChaincodeOpResult that = (ChaincodeOpResult)o;
        return this.id == that.id && Objects.equals(this.jsonrpc, that.jsonrpc) && Objects.equals(this.error, that.error) && Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.jsonrpc, this.id, this.error, this.result);
    }

    public String toString() {
        return "ChaincodeOpResult(jsonrpc=" + this.getJsonrpc() + ", id=" + this.getId() + ", error=" + this.getError() + ", result=" + this.getResult() + ")";
    }

    public static class ChaincodeOpResultBuilder {
        private String jsonrpc;
        private long id;
        private RpcError error;
        private RpcResponse result;

        ChaincodeOpResultBuilder() {
        }

        public ChaincodeOpResultBuilder jsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
            return this;
        }

        public ChaincodeOpResultBuilder id(long id) {
            this.id = id;
            return this;
        }

        public ChaincodeOpResultBuilder error(RpcError error) {
            this.error = error;
            return this;
        }

        public ChaincodeOpResultBuilder result(RpcResponse result) {
            this.result = result;
            return this;
        }

        public ChaincodeOpResult build() {
            return new ChaincodeOpResult(this.jsonrpc, this.id, this.error, this.result);
        }

        public String toString() {
            return "ChaincodeOpResult.ChaincodeOpResultBuilder(jsonrpc=" + this.jsonrpc + ", id=" + this.id + ", error=" + this.error + ", result=" + this.result + ")";
        }
    }
}

