/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.ChaincodeSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaincodeOpPayload {
    private static final Logger log = LoggerFactory.getLogger(ChaincodeOpPayload.class);
    private String jsonrpc;
    private String method;
    private ChaincodeSpec params;
    private long id;

    ChaincodeOpPayload(String jsonrpc, String method, ChaincodeSpec params, long id) {
        this.jsonrpc = jsonrpc;
        this.method = method;
        this.params = params;
        this.id = id;
    }

    public static ChaincodeOpPayloadBuilder builder() {
        return new ChaincodeOpPayloadBuilder();
    }

    public String getJsonrpc() {
        return this.jsonrpc;
    }

    public String getMethod() {
        return this.method;
    }

    public ChaincodeSpec getParams() {
        return this.params;
    }

    public long getId() {
        return this.id;
    }

    public void setJsonrpc(String jsonrpc) {
        this.jsonrpc = jsonrpc;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setParams(ChaincodeSpec params) {
        this.params = params;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChaincodeOpPayload that = (ChaincodeOpPayload)o;
        return this.id == that.id && Objects.equals(this.jsonrpc, that.jsonrpc) && Objects.equals(this.method, that.method) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.jsonrpc, this.method, this.params, this.id);
    }

    public String toString() {
        return "ChaincodeOpPayload(jsonrpc=" + this.getJsonrpc() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ", id=" + this.getId() + ")";
    }

    public static class ChaincodeOpPayloadBuilder {
        private String jsonrpc;
        private String method;
        private ChaincodeSpec params;
        private long id;

        ChaincodeOpPayloadBuilder() {
        }

        public ChaincodeOpPayloadBuilder jsonrpc(String jsonrpc) {
            this.jsonrpc = jsonrpc;
            return this;
        }

        public ChaincodeOpPayloadBuilder method(String method) {
            this.method = method;
            return this;
        }

        public ChaincodeOpPayloadBuilder params(ChaincodeSpec params) {
            this.params = params;
            return this;
        }

        public ChaincodeOpPayloadBuilder id(long id) {
            this.id = id;
            return this;
        }

        public ChaincodeOpPayload build() {
            return new ChaincodeOpPayload(this.jsonrpc, this.method, this.params, this.id);
        }

        public String toString() {
            return "ChaincodeOpPayload.ChaincodeOpPayloadBuilder(jsonrpc=" + this.jsonrpc + ", method=" + this.method + ", params=" + this.params + ", id=" + this.id + ")";
        }
    }
}

