/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaincodeInput {
    private static final Logger LOG = LoggerFactory.getLogger(ChaincodeInput.class);
    private String function;
    private List<String> args;

    ChaincodeInput(String function, List<String> args) {
        this.function = function;
        this.args = args;
    }

    public static ChaincodeInputBuilder builder() {
        return new ChaincodeInputBuilder();
    }

    public String getFunction() {
        return this.function;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChaincodeInput that = (ChaincodeInput)o;
        return Objects.equals(this.function, that.function) && Objects.equals(this.args, that.args);
    }

    public int hashCode() {
        return Objects.hash(this.function, this.args);
    }

    public String toString() {
        return "ChaincodeInput(function=" + this.getFunction() + ", args=" + this.getArgs() + ")";
    }

    public static class ChaincodeInputBuilder {
        private String function;
        private List<String> args;

        ChaincodeInputBuilder() {
        }

        public ChaincodeInputBuilder function(String function) {
            this.function = function;
            return this;
        }

        public ChaincodeInputBuilder arg(String arg) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.add(arg);
            return this;
        }

        public ChaincodeInputBuilder args(Collection<? extends String> args) {
            if (this.args == null) {
                this.args = new ArrayList<String>();
            }
            this.args.addAll(args);
            return this;
        }

        public ChaincodeInputBuilder clearArgs() {
            if (this.args != null) {
                this.args.clear();
            }
            return this;
        }

        public ChaincodeInput build() {
            List<String> args;
            switch (this.args == null ? 0 : this.args.size()) {
                case 0: {
                    args = Collections.emptyList();
                    break;
                }
                case 1: {
                    args = Collections.singletonList(this.args.get(0));
                    break;
                }
                default: {
                    args = Collections.unmodifiableList(new ArrayList<String>(this.args));
                }
            }
            return new ChaincodeInput(this.function, args);
        }

        public String toString() {
            return "ChaincodeInput.ChaincodeInputBuilder(function=" + this.function + ", args=" + this.args + ")";
        }
    }
}

