/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric;

import me.grapebaba.hyperledger.fabric.models.Block;
import me.grapebaba.hyperledger.fabric.models.BlockchainInfo;
import me.grapebaba.hyperledger.fabric.models.ChaincodeOpPayload;
import me.grapebaba.hyperledger.fabric.models.ChaincodeOpResult;
import me.grapebaba.hyperledger.fabric.models.OK;
import me.grapebaba.hyperledger.fabric.models.OK1;
import me.grapebaba.hyperledger.fabric.models.PeersMessage;
import me.grapebaba.hyperledger.fabric.models.Secret;
import me.grapebaba.hyperledger.fabric.models.Transaction;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;
import rx.Observable;

public interface Fabric {
    @GET(value="chain")
    public Observable<BlockchainInfo> getBlockchain();

    @GET(value="chain/blocks/{index}")
    public Observable<Block> getBlock(@Path(value="index") int var1);

    @POST(value="chaincode")
    public Observable<ChaincodeOpResult> chaincode(@Body ChaincodeOpPayload var1);

    @GET(value="transactions/{uuid}")
    public Observable<Transaction> getTransaction(@Path(value="uuid") String var1);

    @POST(value="registrar")
    public Observable<OK> createRegistrar(@Body Secret var1);

    @GET(value="registrar/{enrollmentID}")
    public Observable<OK> getRegistrar(@Path(value="enrollmentID") String var1);

    @DELETE(value="registrar/{enrollmentID}")
    public Observable<OK> deleteRegistrar(@Path(value="enrollmentID") String var1);

    @GET(value="registrar/{enrollmentID}/ecert")
    public Observable<OK> getRegistrarECERT(@Path(value="enrollmentID") String var1);

    @GET(value="registrar/{enrollmentID}/tcert")
    public Observable<OK1> getRegistrarTCERT(@Path(value="enrollmentID") String var1);

    @GET(value="network/peers")
    public Observable<PeersMessage> getNetworkPeers();
}

