/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric;

import java.io.IOException;
import me.grapebaba.hyperledger.fabric.Hyperledger;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.adapter.rxjava.HttpException;

public final class ErrorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorResolver.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T resolve(Throwable throwable, Class<T> tClass) {
        HttpException exception = (HttpException)throwable;
        Converter converter = Hyperledger.CONVERTER_FACTORY.responseBodyConverter(tClass, null, null);
        try (ResponseBody responseBody = exception.response().errorBody();){
            Object object = converter.convert((Object)responseBody);
            return (T)object;
        }
        catch (IOException e) {
            LOG.error("", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

