/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Secret {
    private static final Logger LOG = LoggerFactory.getLogger(Secret.class);
    private String enrollId;
    private String enrollSecret;

    Secret(String enrollId, String enrollSecret) {
        this.enrollId = enrollId;
        this.enrollSecret = enrollSecret;
    }

    public static SecretBuilder builder() {
        return new SecretBuilder();
    }

    public String getEnrollId() {
        return this.enrollId;
    }

    public String getEnrollSecret() {
        return this.enrollSecret;
    }

    public void setEnrollId(String enrollId) {
        this.enrollId = enrollId;
    }

    public void setEnrollSecret(String enrollSecret) {
        this.enrollSecret = enrollSecret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Secret secret = (Secret)o;
        return Objects.equals(this.enrollId, secret.enrollId) && Objects.equals(this.enrollSecret, secret.enrollSecret);
    }

    public int hashCode() {
        return Objects.hash(this.enrollId, this.enrollSecret);
    }

    public String toString() {
        return "Secret(enrollId=" + this.getEnrollId() + ", enrollSecret=" + this.getEnrollSecret() + ")";
    }

    public static class SecretBuilder {
        private String enrollId;
        private String enrollSecret;

        SecretBuilder() {
        }

        public SecretBuilder enrollId(String enrollId) {
            this.enrollId = enrollId;
            return this;
        }

        public SecretBuilder enrollSecret(String enrollSecret) {
            this.enrollSecret = enrollSecret;
            return this;
        }

        public Secret build() {
            return new Secret(this.enrollId, this.enrollSecret);
        }

        public String toString() {
            return "Secret.SecretBuilder(enrollId=" + this.enrollId + ", enrollSecret=" + this.enrollSecret + ")";
        }
    }
}

