/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.PeerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeersMessage {
    private static final Logger LOG = LoggerFactory.getLogger(PeersMessage.class);
    private List<PeerEndpoint> peers;

    PeersMessage(List<PeerEndpoint> peers) {
        this.peers = peers;
    }

    public static PeersMessageBuilder builder() {
        return new PeersMessageBuilder();
    }

    public List<PeerEndpoint> getPeers() {
        return this.peers;
    }

    public void setPeers(List<PeerEndpoint> peers) {
        this.peers = peers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeersMessage that = (PeersMessage)o;
        return Objects.equals(this.peers, that.peers);
    }

    public int hashCode() {
        return Objects.hash(this.peers);
    }

    public String toString() {
        return "PeersMessage(peers=" + this.getPeers() + ")";
    }

    public static class PeersMessageBuilder {
        private List<PeerEndpoint> peers;

        PeersMessageBuilder() {
        }

        public PeersMessageBuilder peer(PeerEndpoint peer) {
            if (this.peers == null) {
                this.peers = new ArrayList<PeerEndpoint>();
            }
            this.peers.add(peer);
            return this;
        }

        public PeersMessageBuilder peers(Collection<? extends PeerEndpoint> peers) {
            if (this.peers == null) {
                this.peers = new ArrayList<PeerEndpoint>();
            }
            this.peers.addAll(peers);
            return this;
        }

        public PeersMessageBuilder clearPeers() {
            if (this.peers != null) {
                this.peers.clear();
            }
            return this;
        }

        public PeersMessage build() {
            List<PeerEndpoint> peers;
            switch (this.peers == null ? 0 : this.peers.size()) {
                case 0: {
                    peers = Collections.emptyList();
                    break;
                }
                case 1: {
                    peers = Collections.singletonList(this.peers.get(0));
                    break;
                }
                default: {
                    peers = Collections.unmodifiableList(new ArrayList<PeerEndpoint>(this.peers));
                }
            }
            return new PeersMessage(peers);
        }

        public String toString() {
            return "PeersMessage.PeersMessageBuilder(peers=" + this.peers + ")";
        }
    }
}

