/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.Timestamp;
import me.grapebaba.hyperledger.fabric.models.TransactionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonHashData {
    private static final Logger LOG = LoggerFactory.getLogger(NonHashData.class);
    private Timestamp localLedgerCommitTimestamp;
    private List<TransactionResult> transactionResults;

    NonHashData(Timestamp localLedgerCommitTimestamp, List<TransactionResult> transactionResults) {
        this.localLedgerCommitTimestamp = localLedgerCommitTimestamp;
        this.transactionResults = transactionResults;
    }

    public static NonHashDataBuilder builder() {
        return new NonHashDataBuilder();
    }

    public Timestamp getLocalLedgerCommitTimestamp() {
        return this.localLedgerCommitTimestamp;
    }

    public List<TransactionResult> getTransactionResults() {
        return this.transactionResults;
    }

    public void setLocalLedgerCommitTimestamp(Timestamp localLedgerCommitTimestamp) {
        this.localLedgerCommitTimestamp = localLedgerCommitTimestamp;
    }

    public void setTransactionResults(List<TransactionResult> transactionResults) {
        this.transactionResults = transactionResults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonHashData that = (NonHashData)o;
        return Objects.equals(this.localLedgerCommitTimestamp, that.localLedgerCommitTimestamp) && Objects.equals(this.transactionResults, that.transactionResults);
    }

    public int hashCode() {
        return Objects.hash(this.localLedgerCommitTimestamp, this.transactionResults);
    }

    public String toString() {
        return "NonHashData(localLedgerCommitTimestamp=" + this.getLocalLedgerCommitTimestamp() + ", transactionResults=" + this.getTransactionResults() + ")";
    }

    public static class NonHashDataBuilder {
        private Timestamp localLedgerCommitTimestamp;
        private ArrayList<TransactionResult> transactionResults;

        NonHashDataBuilder() {
        }

        public NonHashDataBuilder localLedgerCommitTimestamp(Timestamp localLedgerCommitTimestamp) {
            this.localLedgerCommitTimestamp = localLedgerCommitTimestamp;
            return this;
        }

        public NonHashDataBuilder transactionResult(TransactionResult transactionResult) {
            if (this.transactionResults == null) {
                this.transactionResults = new ArrayList();
            }
            this.transactionResults.add(transactionResult);
            return this;
        }

        public NonHashDataBuilder transactionResults(Collection<? extends TransactionResult> transactionResults) {
            if (this.transactionResults == null) {
                this.transactionResults = new ArrayList();
            }
            this.transactionResults.addAll(transactionResults);
            return this;
        }

        public NonHashDataBuilder clearTransactionResults() {
            if (this.transactionResults != null) {
                this.transactionResults.clear();
            }
            return this;
        }

        public NonHashData build() {
            List<TransactionResult> transactionResults;
            switch (this.transactionResults == null ? 0 : this.transactionResults.size()) {
                case 0: {
                    transactionResults = Collections.emptyList();
                    break;
                }
                case 1: {
                    transactionResults = Collections.singletonList(this.transactionResults.get(0));
                    break;
                }
                default: {
                    transactionResults = Collections.unmodifiableList(new ArrayList<TransactionResult>(this.transactionResults));
                }
            }
            return new NonHashData(this.localLedgerCommitTimestamp, transactionResults);
        }

        public String toString() {
            return "NonHashData.NonHashDataBuilder(localLedgerCommitTimestamp=" + this.localLedgerCommitTimestamp + ", transactionResults=" + this.transactionResults + ")";
        }
    }
}

