/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaincodeID {
    private static final Logger LOG = LoggerFactory.getLogger(ChaincodeID.class);
    private String path;
    private String name;

    ChaincodeID(String path, String name) {
        this.path = path;
        this.name = name;
    }

    public static ChaincodeIDBuilder builder() {
        return new ChaincodeIDBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChaincodeID that = (ChaincodeID)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.name);
    }

    public String toString() {
        return "ChaincodeID(path=" + this.getPath() + ", name=" + this.getName() + ")";
    }

    public static class ChaincodeIDBuilder {
        private String path;
        private String name;

        ChaincodeIDBuilder() {
        }

        public ChaincodeIDBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ChaincodeIDBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChaincodeID build() {
            return new ChaincodeID(this.path, this.name);
        }

        public String toString() {
            return "ChaincodeID.ChaincodeIDBuilder(path=" + this.path + ", name=" + this.name + ")";
        }
    }
}

