/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockchainInfo {
    private static final Logger LOG = LoggerFactory.getLogger(BlockchainInfo.class);
    private long height;
    private String currentBlockHash;
    private String previousBlockHash;

    BlockchainInfo(long height, String currentBlockHash, String previousBlockHash) {
        this.height = height;
        this.currentBlockHash = currentBlockHash;
        this.previousBlockHash = previousBlockHash;
    }

    public static BlockchainInfoBuilder builder() {
        return new BlockchainInfoBuilder();
    }

    public long getHeight() {
        return this.height;
    }

    public String getCurrentBlockHash() {
        return this.currentBlockHash;
    }

    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public void setCurrentBlockHash(String currentBlockHash) {
        this.currentBlockHash = currentBlockHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockchainInfo that = (BlockchainInfo)o;
        return this.height == that.height && Objects.equals(this.currentBlockHash, that.currentBlockHash) && Objects.equals(this.previousBlockHash, that.previousBlockHash);
    }

    public int hashCode() {
        return Objects.hash(this.height, this.currentBlockHash, this.previousBlockHash);
    }

    public String toString() {
        return "BlockchainInfo(height=" + this.getHeight() + ", currentBlockHash=" + this.getCurrentBlockHash() + ", previousBlockHash=" + this.getPreviousBlockHash() + ")";
    }

    public static class BlockchainInfoBuilder {
        private long height;
        private String currentBlockHash;
        private String previousBlockHash;

        BlockchainInfoBuilder() {
        }

        public BlockchainInfoBuilder height(long height) {
            this.height = height;
            return this;
        }

        public BlockchainInfoBuilder currentBlockHash(String currentBlockHash) {
            this.currentBlockHash = currentBlockHash;
            return this;
        }

        public BlockchainInfoBuilder previousBlockHash(String previousBlockHash) {
            this.previousBlockHash = previousBlockHash;
            return this;
        }

        public BlockchainInfo build() {
            return new BlockchainInfo(this.height, this.currentBlockHash, this.previousBlockHash);
        }

        public String toString() {
            return "BlockchainInfo.BlockchainInfoBuilder(height=" + this.height + ", currentBlockHash=" + this.currentBlockHash + ", previousBlockHash=" + this.previousBlockHash + ")";
        }
    }
}

