/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import me.grapebaba.hyperledger.fabric.ChaincodeSpecTypeEnumTypeAdapter;
import me.grapebaba.hyperledger.fabric.ConfidentialityLevelEnumTypeAdapter;
import me.grapebaba.hyperledger.fabric.Fabric;
import me.grapebaba.hyperledger.fabric.PeerEndpointTypeEnumTypeAdapter;
import me.grapebaba.hyperledger.fabric.TransactionTypeEnumTypeAdapter;
import me.grapebaba.hyperledger.fabric.models.ChaincodeSpec;
import me.grapebaba.hyperledger.fabric.models.ConfidentialityLevel;
import me.grapebaba.hyperledger.fabric.models.PeerEndpoint;
import me.grapebaba.hyperledger.fabric.models.Transaction;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public final class Hyperledger {
    static final CallAdapter.Factory CALL_ADAPTER_FACTORY = RxJavaCallAdapterFactory.create();
    static final Converter.Factory CONVERTER_FACTORY = GsonConverterFactory.create((Gson)new GsonBuilder().registerTypeAdapter(ChaincodeSpec.Type.class, (Object)new ChaincodeSpecTypeEnumTypeAdapter()).registerTypeAdapter(ConfidentialityLevel.class, (Object)new ConfidentialityLevelEnumTypeAdapter()).registerTypeAdapter(PeerEndpoint.Type.class, (Object)new PeerEndpointTypeEnumTypeAdapter()).registerTypeAdapter(Transaction.Type.class, (Object)new TransactionTypeEnumTypeAdapter()).create());

    public static Fabric fabric(String baseUrl) {
        return (Fabric)new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory(CALL_ADAPTER_FACTORY).addConverterFactory(CONVERTER_FACTORY).build().create(Fabric.class);
    }

    public static Fabric fabric(String baseUrl, Interceptor ... interceptors) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        for (Interceptor interceptor : interceptors) {
            builder.addInterceptor(interceptor);
        }
        return (Fabric)new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory(CALL_ADAPTER_FACTORY).addConverterFactory(CONVERTER_FACTORY).client(builder.build()).build().create(Fabric.class);
    }
}

