/*
 * Decompiled with CFR 0.152.
 */
package protos;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import protos.Fabric;

public class PeerGrpc {
    public static final String SERVICE_NAME = "protos.Peer";
    public static final MethodDescriptor<Fabric.Message, Fabric.Message> METHOD_CHAT = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.BIDI_STREAMING, (String)MethodDescriptor.generateFullMethodName((String)"protos.Peer", (String)"Chat"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Fabric.Message.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Fabric.Message.getDefaultInstance()));
    public static final MethodDescriptor<Fabric.Transaction, Fabric.Response> METHOD_PROCESS_TRANSACTION = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"protos.Peer", (String)"ProcessTransaction"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Fabric.Transaction.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Fabric.Response.getDefaultInstance()));
    private static final int METHODID_PROCESS_TRANSACTION = 0;
    private static final int METHODID_CHAT = 1;

    private PeerGrpc() {
    }

    public static PeerStub newStub(Channel channel) {
        return new PeerStub(channel);
    }

    public static PeerBlockingStub newBlockingStub(Channel channel) {
        return new PeerBlockingStub(channel);
    }

    public static PeerFutureStub newFutureStub(Channel channel) {
        return new PeerFutureStub(channel);
    }

    public static ServiceDescriptor getServiceDescriptor() {
        return new ServiceDescriptor(SERVICE_NAME, new MethodDescriptor[]{METHOD_CHAT, METHOD_PROCESS_TRANSACTION});
    }

    private static class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final PeerImplBase serviceImpl;
        private final int methodId;

        public MethodHandlers(PeerImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    this.serviceImpl.processTransaction((Fabric.Transaction)request, responseObserver);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return this.serviceImpl.chat(responseObserver);
                }
            }
            throw new AssertionError();
        }
    }

    public static final class PeerFutureStub
    extends AbstractStub<PeerFutureStub> {
        private PeerFutureStub(Channel channel) {
            super(channel);
        }

        private PeerFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected PeerFutureStub build(Channel channel, CallOptions callOptions) {
            return new PeerFutureStub(channel, callOptions);
        }

        public ListenableFuture<Fabric.Response> processTransaction(Fabric.Transaction request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PROCESS_TRANSACTION, this.getCallOptions()), (Object)request);
        }
    }

    public static final class PeerBlockingStub
    extends AbstractStub<PeerBlockingStub> {
        private PeerBlockingStub(Channel channel) {
            super(channel);
        }

        private PeerBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected PeerBlockingStub build(Channel channel, CallOptions callOptions) {
            return new PeerBlockingStub(channel, callOptions);
        }

        public Fabric.Response processTransaction(Fabric.Transaction request) {
            return (Fabric.Response)ClientCalls.blockingUnaryCall((Channel)this.getChannel(), METHOD_PROCESS_TRANSACTION, (CallOptions)this.getCallOptions(), (Object)request);
        }
    }

    public static final class PeerStub
    extends AbstractStub<PeerStub> {
        private PeerStub(Channel channel) {
            super(channel);
        }

        private PeerStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected PeerStub build(Channel channel, CallOptions callOptions) {
            return new PeerStub(channel, callOptions);
        }

        public StreamObserver<Fabric.Message> chat(StreamObserver<Fabric.Message> responseObserver) {
            return ClientCalls.asyncBidiStreamingCall((ClientCall)this.getChannel().newCall(METHOD_CHAT, this.getCallOptions()), responseObserver);
        }

        public void processTransaction(Fabric.Transaction request, StreamObserver<Fabric.Response> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PROCESS_TRANSACTION, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static abstract class PeerImplBase
    implements BindableService {
        public StreamObserver<Fabric.Message> chat(StreamObserver<Fabric.Message> responseObserver) {
            return ServerCalls.asyncUnimplementedStreamingCall(METHOD_CHAT, responseObserver);
        }

        public void processTransaction(Fabric.Transaction request, StreamObserver<Fabric.Response> responseObserver) {
            ServerCalls.asyncUnimplementedUnaryCall(METHOD_PROCESS_TRANSACTION, responseObserver);
        }

        public ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)PeerGrpc.getServiceDescriptor()).addMethod(METHOD_CHAT, ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1))).addMethod(METHOD_PROCESS_TRANSACTION, ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).build();
        }
    }
}

