/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timestamp {
    private static final Logger LOG = LoggerFactory.getLogger(Timestamp.class);
    private long seconds;
    private int nanos;

    Timestamp(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public static TimestampBuilder builder() {
        return new TimestampBuilder();
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp timestamp = (Timestamp)o;
        return this.seconds == timestamp.seconds && this.nanos == timestamp.nanos;
    }

    public int hashCode() {
        return Objects.hash(this.seconds, this.nanos);
    }

    public String toString() {
        return "Timestamp(seconds=" + this.getSeconds() + ", nanos=" + this.getNanos() + ")";
    }

    public static class TimestampBuilder {
        private long seconds;
        private int nanos;

        TimestampBuilder() {
        }

        public TimestampBuilder seconds(long seconds) {
            this.seconds = seconds;
            return this;
        }

        public TimestampBuilder nanos(int nanos) {
            this.nanos = nanos;
            return this;
        }

        public Timestamp build() {
            return new Timestamp(this.seconds, this.nanos);
        }

        public String toString() {
            return "Timestamp.TimestampBuilder(seconds=" + this.seconds + ", nanos=" + this.nanos + ")";
        }
    }
}

