/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.PeerID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PeerEndpoint.class);
    @SerializedName(value="ID")
    private PeerID id;
    private String address;
    private Type type;
    private String pkiID;

    PeerEndpoint(PeerID id, String address, Type type, String pkiID) {
        this.id = id;
        this.address = address;
        this.type = type;
        this.pkiID = pkiID;
    }

    public static PeerEndpointBuilder builder() {
        return new PeerEndpointBuilder();
    }

    public PeerID getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public Type getType() {
        return this.type;
    }

    public String getPkiID() {
        return this.pkiID;
    }

    public void setId(PeerID id) {
        this.id = id;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setPkiID(String pkiID) {
        this.pkiID = pkiID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeerEndpoint that = (PeerEndpoint)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.address, that.address) && this.type == that.type && Objects.equals(this.pkiID, that.pkiID);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.address, this.type, this.pkiID});
    }

    public String toString() {
        return "PeerEndpoint(id=" + this.getId() + ", address=" + this.getAddress() + ", type=" + (Object)((Object)this.getType()) + ", pkiID=" + this.getPkiID() + ")";
    }

    public static class PeerEndpointBuilder {
        private PeerID id;
        private String address;
        private Type type;
        private String pkiID;

        PeerEndpointBuilder() {
        }

        public PeerEndpointBuilder id(PeerID id) {
            this.id = id;
            return this;
        }

        public PeerEndpointBuilder address(String address) {
            this.address = address;
            return this;
        }

        public PeerEndpointBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public PeerEndpointBuilder pkiID(String pkiID) {
            this.pkiID = pkiID;
            return this;
        }

        public PeerEndpoint build() {
            return new PeerEndpoint(this.id, this.address, this.type, this.pkiID);
        }

        public String toString() {
            return "PeerEndpoint.PeerEndpointBuilder(id=" + this.id + ", address=" + this.address + ", type=" + (Object)((Object)this.type) + ", pkiID=" + this.pkiID + ")";
        }
    }

    public static enum Type {
        UNDEFINED,
        VALIDATOR,
        NON_VALIDATOR;

    }
}

