/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.ChaincodeID;
import me.grapebaba.hyperledger.fabric.models.ChaincodeInput;
import me.grapebaba.hyperledger.fabric.models.ConfidentialityLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaincodeSpec {
    private static final Logger LOG = LoggerFactory.getLogger(ChaincodeSpec.class);
    private Type type;
    private ChaincodeID chaincodeID;
    private ChaincodeInput ctorMsg;
    private String secureContext;
    private ConfidentialityLevel confidentialityLevel;

    ChaincodeSpec(Type type, ChaincodeID chaincodeID, ChaincodeInput ctorMsg, String secureContext, ConfidentialityLevel confidentialityLevel) {
        this.type = type;
        this.chaincodeID = chaincodeID;
        this.ctorMsg = ctorMsg;
        this.secureContext = secureContext;
        this.confidentialityLevel = confidentialityLevel;
    }

    public static ChaincodeSpecBuilder builder() {
        return new ChaincodeSpecBuilder();
    }

    public Type getType() {
        return this.type;
    }

    public ChaincodeID getChaincodeID() {
        return this.chaincodeID;
    }

    public ChaincodeInput getCtorMsg() {
        return this.ctorMsg;
    }

    public String getSecureContext() {
        return this.secureContext;
    }

    public ConfidentialityLevel getConfidentialityLevel() {
        return this.confidentialityLevel;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setChaincodeID(ChaincodeID chaincodeID) {
        this.chaincodeID = chaincodeID;
    }

    public void setCtorMsg(ChaincodeInput ctorMsg) {
        this.ctorMsg = ctorMsg;
    }

    public void setSecureContext(String secureContext) {
        this.secureContext = secureContext;
    }

    public void setConfidentialityLevel(ConfidentialityLevel confidentialityLevel) {
        this.confidentialityLevel = confidentialityLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChaincodeSpec that = (ChaincodeSpec)o;
        return this.type == that.type && Objects.equals(this.chaincodeID, that.chaincodeID) && Objects.equals(this.ctorMsg, that.ctorMsg) && Objects.equals(this.secureContext, that.secureContext) && this.confidentialityLevel == that.confidentialityLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.chaincodeID, this.ctorMsg, this.secureContext, this.confidentialityLevel});
    }

    public String toString() {
        return "ChaincodeSpec(type=" + (Object)((Object)this.getType()) + ", chaincodeID=" + this.getChaincodeID() + ", ctorMsg=" + this.getCtorMsg() + ", secureContext=" + this.getSecureContext() + ", confidentialityLevel=" + (Object)((Object)this.getConfidentialityLevel()) + ")";
    }

    public static class ChaincodeSpecBuilder {
        private Type type;
        private ChaincodeID chaincodeID;
        private ChaincodeInput ctorMsg;
        private String secureContext;
        private ConfidentialityLevel confidentialityLevel;

        ChaincodeSpecBuilder() {
        }

        public ChaincodeSpecBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public ChaincodeSpecBuilder chaincodeID(ChaincodeID chaincodeID) {
            this.chaincodeID = chaincodeID;
            return this;
        }

        public ChaincodeSpecBuilder ctorMsg(ChaincodeInput ctorMsg) {
            this.ctorMsg = ctorMsg;
            return this;
        }

        public ChaincodeSpecBuilder secureContext(String secureContext) {
            this.secureContext = secureContext;
            return this;
        }

        public ChaincodeSpecBuilder confidentialityLevel(ConfidentialityLevel confidentialityLevel) {
            this.confidentialityLevel = confidentialityLevel;
            return this;
        }

        public ChaincodeSpec build() {
            return new ChaincodeSpec(this.type, this.chaincodeID, this.ctorMsg, this.secureContext, this.confidentialityLevel);
        }

        public String toString() {
            return "ChaincodeSpec.ChaincodeSpecBuilder(type=" + (Object)((Object)this.type) + ", chaincodeID=" + this.chaincodeID + ", ctorMsg=" + this.ctorMsg + ", secureContext=" + this.secureContext + ", confidentialityLevel=" + (Object)((Object)this.confidentialityLevel) + ")";
        }
    }

    public static enum Type {
        UNDEFINED,
        GOLANG,
        NODE;

    }
}

