/*
 * Decompiled with CFR 0.152.
 */
package me.grapebaba.hyperledger.fabric.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.grapebaba.hyperledger.fabric.models.NonHashData;
import me.grapebaba.hyperledger.fabric.models.Timestamp;
import me.grapebaba.hyperledger.fabric.models.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Block {
    private static final Logger LOG = LoggerFactory.getLogger(Block.class);
    private List<Transaction> transactions;
    private Timestamp timestamp;
    private String transactionsHash;
    private String stateHash;
    private String previousBlockHash;
    private String consensusMetadata;
    private NonHashData nonHashData;

    Block(List<Transaction> transactions, Timestamp timestamp, String transactionsHash, String stateHash, String previousBlockHash, String consensusMetadata, NonHashData nonHashData) {
        this.transactions = transactions;
        this.timestamp = timestamp;
        this.transactionsHash = transactionsHash;
        this.stateHash = stateHash;
        this.previousBlockHash = previousBlockHash;
        this.consensusMetadata = consensusMetadata;
        this.nonHashData = nonHashData;
    }

    public static BlockBuilder builder() {
        return new BlockBuilder();
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public String getTransactionsHash() {
        return this.transactionsHash;
    }

    public String getStateHash() {
        return this.stateHash;
    }

    public String getPreviousBlockHash() {
        return this.previousBlockHash;
    }

    public String getConsensusMetadata() {
        return this.consensusMetadata;
    }

    public NonHashData getNonHashData() {
        return this.nonHashData;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public void setTransactionsHash(String transactionsHash) {
        this.transactionsHash = transactionsHash;
    }

    public void setStateHash(String stateHash) {
        this.stateHash = stateHash;
    }

    public void setPreviousBlockHash(String previousBlockHash) {
        this.previousBlockHash = previousBlockHash;
    }

    public void setConsensusMetadata(String consensusMetadata) {
        this.consensusMetadata = consensusMetadata;
    }

    public void setNonHashData(NonHashData nonHashData) {
        this.nonHashData = nonHashData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return Objects.equals(this.transactions, block.transactions) && Objects.equals(this.timestamp, block.timestamp) && Objects.equals(this.transactionsHash, block.transactionsHash) && Objects.equals(this.stateHash, block.stateHash) && Objects.equals(this.previousBlockHash, block.previousBlockHash) && Objects.equals(this.consensusMetadata, block.consensusMetadata) && Objects.equals(this.nonHashData, block.nonHashData);
    }

    public int hashCode() {
        return Objects.hash(this.transactions, this.timestamp, this.transactionsHash, this.stateHash, this.previousBlockHash, this.consensusMetadata, this.nonHashData);
    }

    public String toString() {
        return "Block(transactions=" + this.getTransactions() + ", timestamp=" + this.getTimestamp() + ", transactionsHash=" + this.getTransactionsHash() + ", stateHash=" + this.getStateHash() + ", previousBlockHash=" + this.getPreviousBlockHash() + ", consensusMetadata=" + this.getConsensusMetadata() + ", nonHashData=" + this.getNonHashData() + ")";
    }

    public static class BlockBuilder {
        private List<Transaction> transactions;
        private Timestamp timestamp;
        private String transactionsHash;
        private String stateHash;
        private String previousBlockHash;
        private String consensusMetadata;
        private NonHashData nonHashData;

        BlockBuilder() {
        }

        public BlockBuilder transaction(Transaction transaction) {
            if (this.transactions == null) {
                this.transactions = new ArrayList<Transaction>();
            }
            this.transactions.add(transaction);
            return this;
        }

        public BlockBuilder transactions(Collection<? extends Transaction> transactions) {
            if (this.transactions == null) {
                this.transactions = new ArrayList<Transaction>();
            }
            this.transactions.addAll(transactions);
            return this;
        }

        public BlockBuilder clearTransactions() {
            if (this.transactions != null) {
                this.transactions.clear();
            }
            return this;
        }

        public BlockBuilder timestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public BlockBuilder transactionsHash(String transactionsHash) {
            this.transactionsHash = transactionsHash;
            return this;
        }

        public BlockBuilder stateHash(String stateHash) {
            this.stateHash = stateHash;
            return this;
        }

        public BlockBuilder previousBlockHash(String previousBlockHash) {
            this.previousBlockHash = previousBlockHash;
            return this;
        }

        public BlockBuilder consensusMetadata(String consensusMetadata) {
            this.consensusMetadata = consensusMetadata;
            return this;
        }

        public BlockBuilder nonHashData(NonHashData nonHashData) {
            this.nonHashData = nonHashData;
            return this;
        }

        public Block build() {
            List<Transaction> transactions;
            switch (this.transactions == null ? 0 : this.transactions.size()) {
                case 0: {
                    transactions = Collections.emptyList();
                    break;
                }
                case 1: {
                    transactions = Collections.singletonList(this.transactions.get(0));
                    break;
                }
                default: {
                    transactions = Collections.unmodifiableList(new ArrayList<Transaction>(this.transactions));
                }
            }
            return new Block(transactions, this.timestamp, this.transactionsHash, this.stateHash, this.previousBlockHash, this.consensusMetadata, this.nonHashData);
        }

        public String toString() {
            return "Block.BlockBuilder(transactions=" + this.transactions + ", timestamp=" + this.timestamp + ", transactionsHash=" + this.transactionsHash + ", stateHash=" + this.stateHash + ", previousBlockHash=" + this.previousBlockHash + ", consensusMetadata=" + this.consensusMetadata + ", nonHashData=" + this.nonHashData + ")";
        }
    }
}

