/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout;
import org.apache.logging.log4j.core.layout.JacksonFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.KeyValuePair;

@Plugin(name="LogstashJsonLayout", category="Core", elementType="layout", printObject=true)
public final class LogstashJsonLayout
extends AbstractJacksonLayout {
    private static final String DEFAULT_FOOTER = "]";
    private static final String DEFAULT_HEADER = "[";
    static final String CONTENT_TYPE = "application/json";
    private ObjectMapper objectMapper;

    private LogstashJsonLayout(Configuration config, boolean locationInfo, boolean properties, boolean encodeThreadContextAsList, boolean complete, boolean compact, boolean eventEol, String headerPattern, String footerPattern, Charset charset, boolean includeStacktrace, boolean stacktraceAsString, boolean includeNullDelimiter, KeyValuePair[] additionalFields, boolean objectMessageAsJsonObject) {
        super(config, new JacksonFactory.JSON(encodeThreadContextAsList, includeStacktrace, stacktraceAsString, objectMessageAsJsonObject).newWriter(locationInfo, properties, compact), charset, compact, complete, eventEol, PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(headerPattern).setDefaultPattern(DEFAULT_HEADER).build(), PatternLayout.newSerializerBuilder().setConfiguration(config).setPattern(footerPattern).setDefaultPattern(DEFAULT_FOOTER).build(), includeNullDelimiter, additionalFields);
        this.objectMapper = new Log4jJsonObjectMapper(encodeThreadContextAsList, includeStacktrace, stacktraceAsString, objectMessageAsJsonObject);
    }

    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String str = this.serializeToString(this.getHeaderSerializer());
        if (str != null) {
            buf.append(str);
        }
        buf.append(this.eol);
        return this.getBytes(buf.toString());
    }

    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.eol);
        String str = this.serializeToString(this.getFooterSerializer());
        if (str != null) {
            buf.append(str);
        }
        buf.append(this.eol);
        return this.getBytes(buf.toString());
    }

    public Map<String, String> getContentFormat() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("version", "2.0");
        return result;
    }

    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static LogstashJsonLayout createDefaultLayout() {
        return new LogstashJsonLayout((Configuration)new DefaultConfiguration(), false, false, false, false, false, false, DEFAULT_HEADER, DEFAULT_FOOTER, StandardCharsets.UTF_8, true, false, false, null, false);
    }

    public Object wrapLogEvent(LogEvent event) {
        Map<String, Object> additionalFieldsMap = this.resolveAdditionalFields(event);
        return new LogEventWithAdditionalFields(event, additionalFieldsMap);
    }

    public void toSerializable(LogEvent event, Writer writer) throws IOException {
        if (this.complete && this.eventCount > 0L) {
            writer.append(", ");
        }
        super.toSerializable(event, writer);
    }

    private Map<String, Object> resolveAdditionalFields(LogEvent logEvent) {
        LinkedHashMap<String, Object> additionalFieldsMap = new LinkedHashMap<String, Object>(this.additionalFields.length);
        StrSubstitutor strSubstitutor = this.configuration.getStrSubstitutor();
        for (AbstractJacksonLayout.ResolvableKeyValuePair pair : this.additionalFields) {
            if (pair.valueNeedsLookup) {
                additionalFieldsMap.put(pair.key, strSubstitutor.replace(logEvent, pair.value));
                continue;
            }
            additionalFieldsMap.put(pair.key, pair.value);
        }
        logEvent.getContextData().forEach((key, value) -> {
            try {
                if (this.isJson(value.toString())) {
                    JsonNode node = this.objectMapper.readTree(value.toString());
                    additionalFieldsMap.put((String)key, node);
                } else {
                    additionalFieldsMap.put((String)key, value);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return additionalFieldsMap;
    }

    private boolean isJson(String value) {
        return value.matches("^\\[(.*)]$") || value.matches("^\\{.*}$");
    }

    @JsonRootName(value="Event")
    @JacksonXmlRootElement(namespace="http://logging.apache.org/log4j/2.0/events", localName="Event")
    public static class LogEventWithAdditionalFields {
        private final LogEvent logEvent;
        private final Map<String, Object> additionalFields;
        static final String LOG_STASH_ISO8601_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
        static final DateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

        public LogEventWithAdditionalFields(LogEvent logEvent, Map<String, Object> additionalFields) {
            this.logEvent = logEvent;
            this.additionalFields = additionalFields;
        }

        @JsonUnwrapped
        public Object getLogEvent() {
            return this.logEvent;
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalFields() {
            return this.additionalFields;
        }

        @JsonGetter(value="@version")
        public String getVersion() {
            return "1";
        }

        @JsonGetter(value="@timestamp")
        public String getTimestamp() {
            return iso8601DateFormat.format(new Date(this.logEvent.getTimeMillis()));
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractJacksonLayout.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<LogstashJsonLayout> {
        @PluginBuilderAttribute
        private boolean propertiesAsList;
        @PluginBuilderAttribute
        private boolean objectMessageAsJsonObject;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields;

        public Builder() {
            this.setCharset(StandardCharsets.UTF_8);
        }

        public LogstashJsonLayout build() {
            boolean encodeThreadContextAsList = this.isProperties() && this.propertiesAsList;
            String headerPattern = this.toStringOrNull(this.getHeader());
            String footerPattern = this.toStringOrNull(this.getFooter());
            return new LogstashJsonLayout(this.getConfiguration(), this.isLocationInfo(), this.isProperties(), encodeThreadContextAsList, this.isComplete(), this.isCompact(), this.getEventEol(), headerPattern, footerPattern, this.getCharset(), this.isIncludeStacktrace(), this.isStacktraceAsString(), this.isIncludeNullDelimiter(), this.getAdditionalFields(), this.getObjectMessageAsJsonObject());
        }

        public boolean isPropertiesAsList() {
            return this.propertiesAsList;
        }

        public B setPropertiesAsList(boolean propertiesAsList) {
            this.propertiesAsList = propertiesAsList;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public boolean getObjectMessageAsJsonObject() {
            return this.objectMessageAsJsonObject;
        }

        public B setObjectMessageAsJsonObject(boolean objectMessageAsJsonObject) {
            this.objectMessageAsJsonObject = objectMessageAsJsonObject;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        public B setAdditionalFields(KeyValuePair[] additionalFields) {
            this.additionalFields = additionalFields;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

