/*
 * Decompiled with CFR 0.152.
 */
package me.dhf.dict;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import me.dhf.dict.Select;
import me.dhf.dict.chain.GlobalSelectProcessor;
import me.dhf.dict.chain.SelectProcessor;
import me.dhf.dict.chain.SelectProcessorBuilder;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.Scans;

public class SelectBuilder {
    private static final Log log = Logs.get();
    private boolean systemProperties;
    private SelectProcessor selectProcessor;
    private LinkedList<SelectProcessor> selectFirst;
    private LinkedList<SelectProcessor> selectLast;
    private String[] packages;
    private String jsonFilePath;

    public final SelectBuilder setPackages(String ... packages) {
        this.packages = packages;
        return this;
    }

    public final SelectBuilder setJsonFilePath(String jsonFilePath) {
        this.jsonFilePath = jsonFilePath;
        return this;
    }

    public static SelectBuilder create() {
        return new SelectBuilder();
    }

    public final SelectBuilder useSystemProperties() {
        this.systemProperties = true;
        return this;
    }

    public final SelectBuilder addProcessorFirst(SelectProcessor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.selectFirst == null) {
            this.selectFirst = new LinkedList();
        }
        this.selectFirst.addFirst(itcp);
        return this;
    }

    public final SelectBuilder addProcessorLast(SelectProcessor itcp) {
        if (itcp == null) {
            return this;
        }
        if (this.selectLast == null) {
            this.selectLast = new LinkedList();
        }
        this.selectLast.addLast(itcp);
        return this;
    }

    public void build() {
        SelectProcessor selectProcessorCopy;
        if (this.systemProperties) {
            // empty if block
        }
        if ((selectProcessorCopy = this.selectProcessor) == null) {
            SelectProcessorBuilder b = SelectProcessorBuilder.create();
            if (this.selectFirst != null) {
                for (SelectProcessor i : this.selectFirst) {
                    b.addFirst(i);
                }
            }
            b.addAll(new GlobalSelectProcessor());
            if (this.selectLast != null) {
                for (SelectProcessor i : this.selectLast) {
                    b.addLast(i);
                }
            }
            selectProcessorCopy = b.build();
        }
        HashMap<String, Object> globalDictVal = new HashMap<String, Object>();
        for (String pk : this.packages) {
            for (Class clazz : Scans.me().scanPackage(pk)) {
                Select select = clazz.getAnnotation(Select.class);
                if (select == null) continue;
                String name = select.name();
                Select.Fields value = select.value();
                Select.Fields text = select.text();
                if (Strings.isBlank((CharSequence)name)) {
                    name = Strings.lowerFirst((CharSequence)clazz.getSimpleName());
                }
                Class enumClass = clazz;
                String val = value.name().toLowerCase();
                String txt = text.name().toLowerCase();
                try {
                    Method valMethod = enumClass.getMethod(val, new Class[0]);
                    Method txtMethod = enumClass.getMethod(txt, new Class[0]);
                    Enum[] enumElems = (Enum[])enumClass.getEnumConstants();
                    for (int i = 0; i < enumElems.length; ++i) {
                        Enum enumElem = enumElems[i];
                        String valStr = valMethod.invoke((Object)enumElem, new Object[0]).toString();
                        String txtStr = txtMethod.invoke((Object)enumElem, new Object[0]).toString();
                        selectProcessorCopy.process(valStr, txtStr);
                    }
                    selectProcessorCopy.put(name);
                }
                catch (NoSuchMethodException e) {
                    log.error((Object)"\u679a\u4e3e\u6ca1\u6709\u627e\u5230\u6b64\u65b9\u6cd5", (Throwable)e);
                }
                catch (SecurityException e) {
                    log.error((Object)"SecurityException", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)"IllegalAccessException", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"IllegalArgumentException", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)"InvocationTargetException", (Throwable)e);
                }
            }
        }
        selectProcessorCopy.putGlobalDict(globalDictVal);
        for (Map.Entry entry : globalDictVal.entrySet()) {
            Object dictVal = entry.getValue();
            String key = (String)entry.getKey();
            String valKey = "${" + (String)entry.getKey() + "};";
            String jsonTpl = "var " + key + "=" + valKey + ";";
            String json = jsonTpl.replace(valKey, Json.toJson(dictVal));
            System.out.println(json);
            String fileName = this.jsonFilePath + "/" + key + ".js";
            File file = new File(fileName);
            try {
                if (!file.getParentFile().exists()) {
                    log.info((Object)"\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa\u5b83\uff01");
                    if (!file.getParentFile().mkdirs()) {
                        log.info((Object)"\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
                    }
                }
                if (!file.exists()) {
                    file.createNewFile();
                } else {
                    file.delete();
                    file.createNewFile();
                }
                FileWriter writer = new FileWriter(file, true);
                writer.write(json);
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

