/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nullable;
import me.codeplayer.util.Assert;
import me.codeplayer.util.StringUtil;

public abstract class NumberUtil {
    public static String int2Byte(int i) {
        int index = 32;
        char[] chars = new char[index];
        do {
            chars[--index] = StringUtil.digits[i & 1];
        } while ((i >>>= 1) != 0);
        return new String(chars, index, 32 - index);
    }

    public static byte getByte(Object value) {
        Assert.notNull(value, "\u5c06\u8981\u8f6c\u6362\u4e3a\u6574\u6570\u7684\u503c\u4e0d\u80fd\u4e3anull!");
        return value instanceof Number ? ((Number)value).byteValue() : Byte.parseByte(value.toString());
    }

    public static byte getByte(Object value, byte defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if ("".equals(value)) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static short getShort(Object value) {
        Assert.notNull(value, "\u5c06\u8981\u8f6c\u6362\u4e3a\u6574\u6570\u7684\u503c\u4e0d\u80fd\u4e3anull!");
        return value instanceof Number ? ((Number)value).shortValue() : Short.parseShort(value.toString());
    }

    public static short getShort(Object value, short defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if ("".equals(value)) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getInt(Object value) {
        Assert.notNull(value, "\u5c06\u8981\u8f6c\u6362\u4e3a\u6574\u6570\u7684\u503c\u4e0d\u80fd\u4e3anull!");
        return value instanceof Number ? ((Number)value).intValue() : Integer.parseInt(value.toString());
    }

    public static int getInt(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer getInteger(Object value, Integer defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return value.getClass() == Integer.class ? ((Integer)value).intValue() : ((Number)value).intValue();
        }
        if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static long getLong(Object value) {
        Assert.notNull(value, "\u5c06\u8981\u8f6c\u6362\u4e3a\u6574\u6570\u7684\u503c\u4e0d\u80fd\u4e3anull!");
        return value instanceof Number ? ((Number)value).longValue() : Long.parseLong(value.toString());
    }

    public static long getLong(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long getLong(Object value, Long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return Long.class == value.getClass() ? ((Long)value).longValue() : ((Number)value).longValue();
        }
        if (value instanceof CharSequence && ((CharSequence)value).length() == 0) {
            return defaultValue;
        }
        try {
            return Long.valueOf(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static float getFloat(Object value) {
        Assert.notNull(value, "\u5c06\u8981\u8f6c\u6362\u4e3a\u6574\u6570\u6216\u5c0f\u6570\u7684\u503c\u4e0d\u80fd\u4e3anull!");
        return value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(value.toString());
    }

    public static float getFloat(Object value, float defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if ("".equals(value)) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double getDouble(Object value) {
        Assert.notNull(value, "\u5c06\u8981\u8f6c\u6362\u4e3a\u6574\u6570\u6216\u5c0f\u6570\u7684\u503c\u4e0d\u80fd\u4e3anull!");
        return value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(value.toString());
    }

    public static double getDouble(Object value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if ("".equals(value)) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal getBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Integer || value instanceof Long) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        return new BigDecimal(value.toString());
    }

    public static BigDecimal getBigDecimal(Object value, Object defaultValue) {
        if (value == null) {
            return defaultValue == null ? null : NumberUtil.getBigDecimal(defaultValue);
        }
        try {
            return NumberUtil.getBigDecimal(value);
        }
        catch (Exception e) {
            return defaultValue == null ? null : NumberUtil.getBigDecimal(defaultValue);
        }
    }

    public static boolean isNumber(String str) {
        if (str == null) {
            return false;
        }
        char[] chars = str.toCharArray();
        if (chars.length < 1) {
            return false;
        }
        for (char c : chars) {
            if (Character.isDigit((int)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0!");
        }
        return str != null && str.length() == length && NumberUtil.isNumber(str);
    }

    public static boolean isNumber(Object obj) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            return (double)num.longValue() == num.doubleValue();
        }
        return obj != null && NumberUtil.isNumber(obj.toString());
    }

    public static boolean isNumeric(String str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return false;
        }
        char[] chars = str.toCharArray();
        do {
            if (chars[--length] >= '0' && chars[length] <= '9') continue;
            return false;
        } while (length > 0);
        return true;
    }

    public static boolean isInt(Object value) {
        return value != null && (value instanceof Integer || NumberUtil.isNumber(value.toString()));
    }

    public static boolean isDouble(String str) {
        if (str == null) {
            return false;
        }
        int pointPos = str.indexOf(46, 0) + 1;
        if (pointPos == str.length()) {
            return false;
        }
        if (pointPos > 0) {
            return NumberUtil.isNumeric(str.substring(0, pointPos - 1)) && NumberUtil.isNumeric(str.substring(pointPos));
        }
        return NumberUtil.isNumeric(str);
    }

    public static boolean isDouble(Object value) {
        return value != null && (value instanceof Number || NumberUtil.isDouble(value.toString()));
    }

    protected static boolean isPositive(@Nullable Number val, boolean allowZero) {
        if (val != null) {
            if (val instanceof Integer) {
                return allowZero ? val.intValue() >= 0 : val.intValue() > 0;
            }
            if (val instanceof Long) {
                return allowZero ? val.longValue() >= 0L : val.longValue() > 0L;
            }
            return allowZero ? val.doubleValue() >= 0.0 : val.doubleValue() > 0.0;
        }
        return false;
    }

    public static boolean isPositive(@Nullable Number val) {
        return NumberUtil.isPositive(val, false);
    }

    public static boolean isNonNegative(@Nullable Number val) {
        return NumberUtil.isPositive(val, true);
    }
}

