/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.validator;

import java.math.BigDecimal;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.codeplayer.util.NumberUtil;
import me.codeplayer.util.StringUtil;
import me.codeplayer.validator.Pipeline;
import me.codeplayer.validator.PropertyAccessor;

public abstract class Validators {
    public static final Function<Object, String> trim = StringUtil::trim;
    public static final Function<Object, String> toString = StringUtil::toString;
    public static final Function<String, String> lower = String::toLowerCase;
    public static final Function<String, String> upper = String::toUpperCase;
    public static final Predicate<Object> assertNotEmpty = StringUtil::notEmpty;
    public static final Predicate<Object> assertNotBlank = StringUtil::notBlank;
    public static final Predicate<Object> assertIsNumber = NumberUtil::isNumber;
    public static final Predicate<String> assertIsNonNegative = NumberUtil::isNumeric;
    public static final Predicate<Number> assertPositive = NumberUtil::isPositive;
    public static final Predicate<Number> assertNonNegative = NumberUtil::isNonNegative;

    public static <T, R> Pipeline<T, R> of(T bean, Function<? super T, R> getter, @Nullable BiConsumer<? super T, R> setter) {
        return new Pipeline(bean).begin(getter, setter);
    }

    public static <T, R> Pipeline<T, R> of(T bean, Function<? super T, R> getter) {
        return new Pipeline(bean).begin(getter, (BiConsumer)null);
    }

    public static <T, R> Pipeline<T, R> of(T bean, PropertyAccessor<? super T, R> accessor) {
        return new Pipeline(bean).begin(accessor);
    }

    public static <T, R> Pipeline<T, R> of(T bean) {
        return new Pipeline(bean);
    }

    public static Predicate<CharSequence> assertLength(int min, int max) {
        return val -> val == null && min <= -1 || val != null && val.length() >= min && (max <= -1 || max >= val.length());
    }

    public static Predicate<Integer> assertRange(int min, int max) {
        return val -> val != null && val >= min && val <= max;
    }

    public static Predicate<Long> assertRange(long min, long max) {
        return val -> val != null && val >= min && val <= max;
    }

    public static Predicate<Double> assertRange(double min, double max) {
        return val -> val != null && val >= min && val <= max;
    }

    public static Predicate<BigDecimal> assertRange(@Nullable BigDecimal min, @Nullable BigDecimal max) {
        return val -> !(val == null || min != null && val.compareTo(min) < 0 || max != null && max.compareTo((BigDecimal)val) < 0);
    }
}

