/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.HashMap;
import java.util.Map;

public abstract class ThreadLocalUtil {
    private static final ThreadLocal<Map<Object, Object>> LOCAL_CACHE = new ThreadLocal();

    public static Map<Object, Object> getMap() {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        if (cache == null) {
            cache = new HashMap<Object, Object>();
            LOCAL_CACHE.set(cache);
        }
        return cache;
    }

    public static Object put(Object key, Object value) {
        return ThreadLocalUtil.getMap().put(key, value);
    }

    public static Object get(Object key) {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        return cache == null ? null : cache.get(key);
    }

    public static void clear() {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        if (cache != null) {
            cache.clear();
            LOCAL_CACHE.remove();
        }
    }

    public static int size() {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        return cache == null ? 0 : cache.size();
    }

    public static boolean isEmpty() {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        return cache == null || cache.isEmpty();
    }

    public static boolean containsKey(Object key) {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        return cache != null && cache.containsKey(key);
    }

    public static boolean containsValue(Object key) {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        return cache != null && cache.containsValue(key);
    }

    public static void pubAll(Map<Object, Object> map) {
        ThreadLocalUtil.getMap().putAll(map);
    }

    public static void reset(Map<Object, Object> map) {
        LOCAL_CACHE.set(map);
    }

    public static Object remove(Object key) {
        Map<Object, Object> cache = LOCAL_CACHE.get();
        return cache == null ? null : cache.remove(key);
    }

    public static void destroy() {
        LOCAL_CACHE.remove();
    }
}

