/*
 * Decompiled with CFR 0.152.
 */
package me.codeplayer.util;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import me.codeplayer.util.StringUtil;

public abstract class Assert {
    public static void isTrue(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void isTrue(boolean expression, @Nullable CharSequence errorMsg) {
        if (!expression) {
            throw new IllegalArgumentException(StringUtil.nullSafeGet(errorMsg));
        }
    }

    public static void isTrue(boolean expression, @Nullable Supplier<? extends CharSequence> msger) {
        if (!expression) {
            throw new IllegalArgumentException(StringUtil.nullSafeGet(msger));
        }
    }

    public static void state(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    public static void state(boolean expression, @Nullable CharSequence errorMsg) {
        if (!expression) {
            throw new IllegalStateException(StringUtil.nullSafeGet(errorMsg));
        }
    }

    public static void state(boolean expression, @Nullable Supplier<? extends CharSequence> msger) {
        if (!expression) {
            throw new IllegalStateException(StringUtil.nullSafeGet(msger));
        }
    }

    public static void notTrue(boolean expression, @Nullable CharSequence errorMsg) {
        Assert.isTrue(!expression, errorMsg);
    }

    public static void notTrue(boolean expression, @Nullable Supplier<? extends CharSequence> msger) {
        Assert.isTrue(!expression, msger);
    }

    public static void isNull(Object object) {
        Assert.isTrue(object == null);
    }

    public static void isNull(@Nullable Object object, @Nullable CharSequence errorMsg) {
        Assert.isTrue(object == null, errorMsg);
    }

    public static <T> T notNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static <T> T notNull(@Nullable T obj, @Nullable CharSequence errorMsg) {
        if (obj == null) {
            throw new NullPointerException(StringUtil.nullSafeGet(errorMsg));
        }
        return obj;
    }

    public static <T> T notNull(@Nullable T obj, @Nullable Supplier<? extends CharSequence> msger) {
        if (obj == null) {
            throw new NullPointerException(StringUtil.nullSafeGet(msger));
        }
        return obj;
    }

    public static <T> T isEmpty(@Nullable T str, @Nullable CharSequence errorMsg) {
        Assert.isTrue(StringUtil.isEmpty(str), errorMsg);
        return str;
    }

    public static <T> T isEmpty(T str) {
        Assert.isTrue(StringUtil.isEmpty(str));
        return str;
    }

    public static <T> T notEmpty(T str) {
        Assert.isTrue(StringUtil.notEmpty(str));
        return str;
    }

    public static void notEmpty(@Nullable Object str, @Nullable CharSequence errorMsg) {
        Assert.isTrue(StringUtil.notEmpty(str), errorMsg);
    }

    public static void notEmpty(@Nullable Object str, @Nullable Supplier<? extends CharSequence> errorMsg) {
        Assert.isTrue(StringUtil.notEmpty(str), errorMsg);
    }

    public static <T> T isBlank(T obj, String errorMsg) {
        Assert.isTrue(StringUtil.isBlank(obj), errorMsg);
        return obj;
    }

    public static <T> T notBlank(T obj) {
        Assert.isTrue(StringUtil.notBlank(obj));
        return obj;
    }

    public static <T> T notBlank(@Nullable T obj, @Nullable CharSequence errorMsg) {
        Assert.isTrue(StringUtil.notBlank(obj), errorMsg);
        return obj;
    }

    public static void equals(@Nullable Object obj, @Nullable Object another, @Nullable CharSequence errorMsg) {
        Assert.isTrue(obj == another || obj != null && obj.equals(another), errorMsg);
    }

    public static void notEquals(@Nullable Object obj, @Nullable Object another, @Nullable CharSequence errorMsg) {
        Assert.notTrue(obj == another || obj != null && obj.equals(another), errorMsg);
    }

    public static void isSame(Object obj, Object another, CharSequence errorMsg) {
        Assert.isTrue(obj == another, errorMsg);
    }

    public static void notSame(Object obj, Object another, CharSequence errorMsg) {
        Assert.notTrue(obj == another, errorMsg);
    }
}

